/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedBatchConfigurer;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedRunnerJobFactory;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedTaskRunnerTaskListener;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedTaskStepExecutionListener;
import org.springframework.cloud.dataflow.composedtaskrunner.StepBeanDefinitionRegistrar;
import org.springframework.cloud.dataflow.composedtaskrunner.TaskExplorerContainer;
import org.springframework.cloud.dataflow.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.dataflow.core.database.support.MultiSchemaTaskExecutionDaoFactoryBean;
import org.springframework.cloud.dataflow.core.dsl.TaskParser;
import org.springframework.cloud.dataflow.core.dsl.TaskVisitor;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.cloud.task.listener.TaskExecutionListener;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.cloud.task.repository.support.SimpleTaskExplorer;
import org.springframework.cloud.task.repository.support.TaskExecutionDaoFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@EnableBatchProcessing
@EnableTask
@EnableConfigurationProperties(value={ComposedTaskProperties.class})
@Configuration
@Import(value={StepBeanDefinitionRegistrar.class})
public class ComposedTaskRunnerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ComposedTaskRunnerConfiguration.class);

    @Bean
    public TaskExecutionListener taskExecutionListener() {
        return new ComposedTaskRunnerTaskListener();
    }

    @Bean
    public StepExecutionListener composedTaskStepExecutionListener(TaskExplorerContainer taskExplorerContainer) {
        return new ComposedTaskStepExecutionListener(taskExplorerContainer);
    }

    @Bean
    TaskExplorerContainer taskExplorerContainer(TaskExplorer taskExplorer, DataSource dataSource, ComposedTaskProperties properties, Environment env) {
        HashMap explorers = new HashMap();
        String ctrName = env.getProperty("spring.cloud.task.name");
        if (!StringUtils.hasText((String)ctrName)) {
            throw new IllegalStateException("spring.cloud.task.name property must have a value.");
        }
        TaskParser parser = new TaskParser("ctr", properties.getGraph(), false, true);
        StepBeanDefinitionRegistrar.TaskAppsMapCollector collector = new StepBeanDefinitionRegistrar.TaskAppsMapCollector();
        parser.parse().accept((TaskVisitor)collector);
        Set taskNames = collector.getTaskApps().keySet();
        logger.debug("taskExplorerContainer:taskNames:{}", taskNames);
        for (String taskName : taskNames) {
            ComposedTaskRunnerConfiguration.addTaskExplorer((DataSource)dataSource, (ComposedTaskProperties)properties, (Environment)env, explorers, (String)taskName);
            String appName = taskName.replace(ctrName + "-", "");
            ComposedTaskRunnerConfiguration.addTaskExplorer((DataSource)dataSource, (ComposedTaskProperties)properties, (Environment)env, explorers, (String)appName);
            if (taskName.length() <= ctrName.length()) continue;
            String shortTaskName = taskName.substring(ctrName.length() + 1);
            ComposedTaskRunnerConfiguration.addTaskExplorer((DataSource)dataSource, (ComposedTaskProperties)properties, (Environment)env, explorers, (String)shortTaskName);
        }
        return new TaskExplorerContainer(explorers, taskExplorer);
    }

    private static void addTaskExplorer(DataSource dataSource, ComposedTaskProperties properties, Environment env, Map<String, TaskExplorer> explorers, String taskName) {
        logger.debug("addTaskExplorer:{}", (Object)taskName);
        String propertyName = String.format("app.%s.spring.cloud.task.tablePrefix", taskName);
        String prefix = (String)properties.getComposedTaskAppProperties().get(propertyName);
        if (prefix == null) {
            prefix = env.getProperty(propertyName);
        }
        if (prefix != null) {
            MultiSchemaTaskExecutionDaoFactoryBean factoryBean = new MultiSchemaTaskExecutionDaoFactoryBean(dataSource, prefix);
            logger.debug("taskExplorerContainer:adding:{}:{}", (Object)taskName, (Object)prefix);
            explorers.put(taskName, (TaskExplorer)new SimpleTaskExplorer((TaskExecutionDaoFactoryBean)factoryBean));
        } else {
            logger.warn("Cannot find {} in {} ", (Object)propertyName, (Object)properties.getComposedTaskAppProperties());
        }
    }

    @Bean
    public ComposedRunnerJobFactory composedTaskJob(ComposedTaskProperties properties) {
        return new ComposedRunnerJobFactory(properties);
    }

    @Bean
    public TaskExecutor taskExecutor(ComposedTaskProperties properties) {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(properties.getSplitThreadCorePoolSize());
        taskExecutor.setMaxPoolSize(properties.getSplitThreadMaxPoolSize());
        taskExecutor.setKeepAliveSeconds(properties.getSplitThreadKeepAliveSeconds());
        taskExecutor.setAllowCoreThreadTimeOut(properties.isSplitThreadAllowCoreThreadTimeout());
        taskExecutor.setQueueCapacity(properties.getSplitThreadQueueCapacity());
        taskExecutor.setWaitForTasksToCompleteOnShutdown(properties.isSplitThreadWaitForTasksToCompleteOnShutdown());
        return taskExecutor;
    }

    @Bean
    public BatchConfigurer getComposedBatchConfigurer(BatchProperties properties, DataSource dataSource, TransactionManagerCustomizers transactionManagerCustomizers, ComposedTaskProperties composedTaskProperties) {
        return new ComposedBatchConfigurer(properties, dataSource, transactionManagerCustomizers, composedTaskProperties);
    }
}

