/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;

public class CompletionUtils {
    static final Set<String> IMPLICIT_PARAMETER_NAMES = new HashSet<String>();
    static final Set<String> IMPLICIT_TASK_PARAMETER_NAMES = new HashSet<String>();

    static ApplicationType[] determinePotentialTypes(StreamAppDefinition appDefinition, boolean multipleAppsInStreamDefinition) {
        ApplicationType[] result = null;
        Set properties = appDefinition.getProperties().keySet();
        result = properties.contains("spring.cloud.stream.bindings.input.destination") ? (properties.contains("spring.cloud.stream.bindings.output.destination") ? new ApplicationType[]{ApplicationType.processor} : new ApplicationType[]{ApplicationType.processor, ApplicationType.sink}) : (multipleAppsInStreamDefinition ? new ApplicationType[]{ApplicationType.app} : new ApplicationType[]{ApplicationType.source, ApplicationType.app});
        return result;
    }

    static String maybeQualifyWithLabel(String appName, LinkedList<StreamAppDefinition> streamAppDefinitions) {
        String candidate = appName;
        HashSet<String> alreadyUsed = new HashSet<String>();
        for (StreamAppDefinition appDefinition : streamAppDefinitions) {
            alreadyUsed.add(appDefinition.getName());
        }
        String result = candidate;
        int counter = 2;
        while (alreadyUsed.contains(candidate)) {
            candidate = appName + counter++;
            result = String.format("%s: %s", candidate, appName);
        }
        return result;
    }

    static boolean isMatchingProperty(String propertyName, ConfigurationMetadataProperty property, List<ConfigurationMetadataProperty> visibleProps) {
        if (property.getId().equals(propertyName)) {
            return true;
        }
        for (ConfigurationMetadataProperty visible : visibleProps) {
            if (!property.getId().equals(visible.getId())) continue;
            return property.getName().equals(propertyName);
        }
        return false;
    }

    static {
        IMPLICIT_PARAMETER_NAMES.add("spring.cloud.stream.bindings.input.destination");
        IMPLICIT_PARAMETER_NAMES.add("spring.cloud.stream.bindings.input.group");
        IMPLICIT_PARAMETER_NAMES.add("spring.cloud.stream.bindings.output.producer.requiredGroups");
        IMPLICIT_PARAMETER_NAMES.add("spring.cloud.stream.bindings.output.destination");
        IMPLICIT_TASK_PARAMETER_NAMES.add("spring.cloud.task.name");
    }
}

