/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.TaskExpansionStrategy;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.registry.AppRegistryCommon;
import org.springframework.cloud.dataflow.registry.domain.AppRegistration;

public class UnfinishedTaskAppNameExpansionStrategy
implements TaskExpansionStrategy {
    private final AppRegistryCommon appRegistry;

    UnfinishedTaskAppNameExpansionStrategy(AppRegistryCommon appRegistry) {
        this.appRegistry = appRegistry;
    }

    @Override
    public boolean addProposals(String text, TaskDefinition taskDefinition, int detailLevel, List<CompletionProposal> collector) {
        HashSet parameterNames = new HashSet(taskDefinition.getProperties().keySet());
        parameterNames.removeAll(CompletionUtils.IMPLICIT_TASK_PARAMETER_NAMES);
        if (!parameterNames.isEmpty() || !text.endsWith(taskDefinition.getRegisteredAppName())) {
            return false;
        }
        String alreadyTyped = taskDefinition.getRegisteredAppName();
        CompletionProposal.Factory proposals = CompletionProposal.expanding(text);
        List<ApplicationType> validTypesAtThisPosition = Arrays.asList(ApplicationType.task);
        for (AppRegistration appRegistration : this.appRegistry.findAll()) {
            String candidateName = appRegistration.getName();
            if (!validTypesAtThisPosition.contains(appRegistration.getType()) || alreadyTyped.equals(candidateName) || !candidateName.startsWith(alreadyTyped)) continue;
            String expansion = appRegistration.getName();
            collector.add(proposals.withSuffix(expansion.substring(alreadyTyped.length())));
        }
        return false;
    }
}

