/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.ProposalsCollectorSupportUtils;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingTaskRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.ValueHintProvider;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;
import org.springframework.cloud.dataflow.registry.AppRegistryCommon;
import org.springframework.cloud.dataflow.registry.domain.AppRegistration;

public class ConfigurationPropertyValueHintTaskRecoveryStrategy
extends StacktraceFingerprintingTaskRecoveryStrategy<CheckPointedParseException> {
    private final ProposalsCollectorSupportUtils collectorSupport;
    @Autowired
    private ValueHintProvider[] valueHintProviders = new ValueHintProvider[0];

    ConfigurationPropertyValueHintTaskRecoveryStrategy(AppRegistryCommon appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        super(CheckPointedParseException.class, "foo --bar=");
        this.collectorSupport = new ProposalsCollectorSupportUtils(appRegistry, metadataResolver);
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> collector) {
        String propertyName = this.recoverPropertyName(exception);
        AppRegistration appRegistration = this.lookupLastApp(exception);
        if (appRegistration != null) {
            this.collectorSupport.addValueHintsProposals(dsl, appRegistration, collector, propertyName, this.valueHintProviders);
        }
    }

    private AppRegistration lookupLastApp(CheckPointedParseException exception) {
        String safe = exception.getExpressionStringUntilCheckpoint();
        TaskDefinition taskDefinition = new TaskDefinition("__dummy", safe);
        return this.collectorSupport.findAppRegistration(taskDefinition.getRegisteredAppName(), ApplicationType.task);
    }

    private String recoverPropertyName(CheckPointedParseException exception) {
        List tokens = exception.getTokens();
        int tokenPointer = tokens.size() - 1;
        while (!((Token)tokens.get(tokenPointer - 1)).isKind(TokenKind.DOUBLE_MINUS)) {
            --tokenPointer;
        }
        int equalSignPointer = tokens.size() - 1;
        StringBuilder builder = new StringBuilder();
        while (tokenPointer < equalSignPointer) {
            Token t = (Token)tokens.get(tokenPointer);
            if (t.isIdentifier()) {
                builder.append(t.stringValue());
            } else {
                builder.append(t.getKind().getTokenChars());
            }
            ++tokenPointer;
        }
        return builder.toString();
    }
}

