/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.common.flyway;

import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.common.flyway.SqlCommand;
import org.springframework.cloud.dataflow.common.flyway.SuppressDataAccessException;
import org.springframework.cloud.dataflow.common.flyway.SuppressSQLErrorCodesTranslator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.util.ObjectUtils;

public class SqlCommandsRunner {
    private static final Logger logger = LoggerFactory.getLogger(SqlCommandsRunner.class);

    public void execute(Connection connection, List<SqlCommand> commands) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)new SingleConnectionDataSource(connection, true));
        SQLExceptionTranslator origExceptionTranslator = jdbcTemplate.getExceptionTranslator();
        for (SqlCommand command : commands) {
            if (command.canHandleInJdbcTemplate()) {
                command.handle(jdbcTemplate, connection);
                continue;
            }
            if (!ObjectUtils.isEmpty(command.getSuppressedErrorCodes())) {
                jdbcTemplate.setExceptionTranslator((SQLExceptionTranslator)new SuppressSQLErrorCodesTranslator(command.getSuppressedErrorCodes()));
            }
            try {
                logger.debug("Executing command {}", (Object)command.getCommand());
                jdbcTemplate.execute(command.getCommand());
            }
            catch (SuppressDataAccessException e) {
                logger.debug("Suppressing error {}", (Throwable)((Object)e));
            }
            jdbcTemplate.setExceptionTranslator(origExceptionTranslator);
        }
    }
}

