/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.common.flyway;

import java.util.List;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Event;
import org.springframework.cloud.dataflow.common.flyway.DataFlowSchemaMigrationException;
import org.springframework.cloud.dataflow.common.flyway.SqlCommand;
import org.springframework.cloud.dataflow.common.flyway.SqlCommandsRunner;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.util.ObjectUtils;

public abstract class AbstractCallback
implements Callback {
    private final Event event;
    private final List<SqlCommand> commands;
    private final SqlCommandsRunner runner = new SqlCommandsRunner();

    public AbstractCallback(Event event) {
        this(event, null);
    }

    public AbstractCallback(Event event, List<SqlCommand> commands) {
        this.event = event;
        this.commands = commands;
    }

    public boolean supports(Event event, Context context) {
        return ObjectUtils.nullSafeEquals((Object)this.event, (Object)event);
    }

    public boolean canHandleInTransaction(Event event, Context context) {
        return true;
    }

    public void handle(Event event, Context context) {
        try {
            this.runner.execute(context.getConnection(), this.getCommands(event, context));
        }
        catch (Exception sqe) {
            if (sqe instanceof BadSqlGrammarException) {
                throw new DataFlowSchemaMigrationException("An exception occured during migration.  This may indicate that you have run Spring Batch Jobs or Spring Cloud Tasks prior to running Spring Cloud Data Flow first. Data Flow must create these tables.", sqe);
            }
            throw sqe;
        }
    }

    public List<SqlCommand> getCommands(Event event, Context context) {
        return this.commands;
    }
}

