/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.common.flyway;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class FlywayVendorReplacingApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private final Logger log = LoggerFactory.getLogger(FlywayVendorReplacingApplicationContextInitializer.class);

    public void initialize(ConfigurableApplicationContext applicationContext) {
        String locationPropName;
        String configuredLocation;
        ConfigurableEnvironment env = applicationContext.getEnvironment();
        boolean usingMariaDriver = env.getProperty("spring.datasource.driver-class-name", "").equals("org.mariadb.jdbc.Driver");
        boolean usingMySqlUrl = env.getProperty("spring.datasource.url", "").startsWith("jdbc:mysql:");
        if (!usingMariaDriver || !usingMySqlUrl) {
            return;
        }
        this.log.info("Using MariaDB driver w/ MySQL url - looking for '{vendor}' in 'spring.flyway.locations'");
        HashMap<String, String> replacedLocations = new HashMap<String, String>();
        int prodIdx = 0;
        while ((configuredLocation = env.getProperty(locationPropName = String.format("spring.flyway.locations[%d]", prodIdx++))) != null) {
            if (!configuredLocation.contains("{vendor}")) continue;
            String replaceLocation = configuredLocation.replace("{vendor}", "mysql");
            replacedLocations.put(locationPropName, replaceLocation);
        }
        if (replacedLocations.isEmpty()) {
            this.log.info("No properties with '{vendor}' found to replace");
            return;
        }
        this.log.info("Replacing '{vendor}' in {}", replacedLocations);
        env.getPropertySources().addFirst((PropertySource)new MapPropertySource("overrideVendorInFlywayLocations", replacedLocations));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

