/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.app.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.ExplodedArchive;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.cloud.dataflow.configuration.metadata.BootApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.configuration.metadata.BootClassLoaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Mojo(name="generate-documentation", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ConfigurationMetadataDocumentationMojo
extends AbstractMojo {
    static final String CONFIGURATION_PROPERTIES_START_TAG = "//tag::configuration-properties[";
    static final String CONFIGURATION_PROPERTIES_END_TAG = "//end::configuration-properties[]";
    private static final Map<String, String> APPTYPE_TO_FUNCTIONTYPE = Map.of("source", "supplier", "processor", "function", "sink", "consumer");
    private BootApplicationConfigurationMetadataResolver metadataResolver = new BootApplicationConfigurationMetadataResolver(imageName -> null);
    @Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    @Parameter(defaultValue="false")
    private boolean failOnMissingDescription;
    private boolean grouped = true;

    public void execute() throws MojoExecutionException {
        File readme = new File(this.mavenProject.getBasedir(), "README.adoc");
        if (!readme.exists()) {
            this.getLog().info((CharSequence)String.format("No README.adoc file found in %s, skipping", this.mavenProject.getBasedir()));
            return;
        }
        Artifact artifact = this.mavenProject.getArtifact();
        if (artifact.getFile() == null) {
            this.getLog().info((CharSequence)String.format("Project in %s does not produce a build artifact, skipping", this.mavenProject.getBasedir()));
            return;
        }
        File tmp = new File(readme.getPath() + ".tmp");
        try (PrintWriter out = new PrintWriter(tmp);
             BufferedReader reader = new BufferedReader(new FileReader(readme));){
            boolean linkToFunctionCatalog;
            String line;
            do {
                line = reader.readLine();
                out.println(line);
            } while (line != null && !line.startsWith(CONFIGURATION_PROPERTIES_START_TAG));
            if (line == null) {
                this.getLog().info((CharSequence)"No documentation section marker found");
                return;
            }
            Map<String, String> startTagAttributes = this.startTagAttributes(line);
            if ("false".equals(startTagAttributes.get("group"))) {
                this.grouped = false;
            }
            if (linkToFunctionCatalog = "true".equals(startTagAttributes.get("link-to-catalog"))) {
                this.handleExternalLinkToFunctionsCatalog(artifact, out);
            } else {
                this.handleInlineConfigProperties(out);
            }
            while (!(line = reader.readLine()).startsWith(CONFIGURATION_PROPERTIES_END_TAG)) {
            }
            while (line != null) {
                out.println(line);
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            tmp.delete();
            throw new MojoExecutionException("Error generating documentation", e);
        }
        try {
            Files.move(tmp.toPath(), readme.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error moving tmp file to README.adoc", (Exception)e);
        }
    }

    private void handleExternalLinkToFunctionsCatalog(Artifact artifact, PrintWriter out) {
        String artifactId = artifact.getArtifactId();
        String appName = artifactId.substring(0, artifactId.lastIndexOf(45));
        String appType = artifactId.substring(artifactId.lastIndexOf(45) + 1);
        String functionType = APPTYPE_TO_FUNCTIONTYPE.get(appType);
        String functionName = "spring-%s-%s".formatted(appName, functionType);
        String url = "https://github.com/spring-cloud/spring-functions-catalog/tree/main/%s/%s#configuration-options[See Spring Functions Catalog for configuration options].".formatted(functionType, functionName);
        out.println(url);
    }

    private void handleInlineConfigProperties(PrintWriter out) throws IOException {
        ScatteredArchive archive = new ScatteredArchive(this.mavenProject);
        BootClassLoaderFactory bootClassLoaderFactory = new BootClassLoaderFactory((Archive)archive, null);
        try (URLClassLoader classLoader = bootClassLoaderFactory.createClassLoader();){
            this.debug(classLoader);
            List properties = this.metadataResolver.listProperties((Archive)archive, false);
            Collections.sort(properties, Comparator.comparing(ConfigurationMetadataProperty::getId));
            Map<String, List<ConfigurationMetadataProperty>> groupedProperties = this.groupProperties(properties);
            boolean bl = this.grouped = this.grouped && groupedProperties.size() > 1;
            if (this.grouped) {
                out.println("Properties grouped by prefix:\n");
                groupedProperties.forEach((group, props) -> {
                    this.getLog().debug((CharSequence)(" Documenting group " + group));
                    out.println(this.asciidocForGroup((String)group));
                    this.listProperties((List<ConfigurationMetadataProperty>)props, out, classLoader, prop -> prop.getName());
                });
            } else {
                this.listProperties(properties, out, classLoader, prop -> prop.getId());
            }
            this.getLog().info((CharSequence)String.format("Documented %d configuration properties", properties.size()));
        }
    }

    private void listProperties(List<ConfigurationMetadataProperty> properties, PrintWriter out, ClassLoader classLoader, Function<ConfigurationMetadataProperty, String> propertyValue) {
        for (ConfigurationMetadataProperty property : properties) {
            this.getLog().debug((CharSequence)("Documenting " + property.getId()));
            out.println(this.asciidocFor(property, classLoader, propertyValue));
        }
    }

    private Map<String, List<ConfigurationMetadataProperty>> groupProperties(List<ConfigurationMetadataProperty> properties) {
        LinkedHashMap<String, List<ConfigurationMetadataProperty>> groupedProperties = new LinkedHashMap<String, List<ConfigurationMetadataProperty>>();
        properties.forEach(property -> {
            String group = this.group(property.getId());
            if (!groupedProperties.containsKey(group)) {
                groupedProperties.put(group, new LinkedList());
            }
            ((List)groupedProperties.get(group)).add(property);
        });
        return groupedProperties;
    }

    private String group(String id) {
        return id.lastIndexOf(46) > 0 ? id.substring(0, id.lastIndexOf(46)) : "";
    }

    private void debug(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            List<URL> urls = Arrays.asList(((URLClassLoader)classLoader).getURLs());
            this.getLog().debug((CharSequence)("Classloader has the following URLs:\n" + urls.toString().replace(',', '\n')));
        }
    }

    private String asciidocFor(ConfigurationMetadataProperty property, ClassLoader classLoader, Function<ConfigurationMetadataProperty, String> propertyValue) {
        return String.format("$$%s$$:: $$%s$$ *($$%s$$, default: `$$%s$$`%s)*", propertyValue.apply(property), this.niceDescription(property), this.niceType(property), this.niceDefault(property), this.maybeHints(property, classLoader));
    }

    private String asciidocForGroup(String group) {
        return "\n=== " + group + "\n";
    }

    private Map<String, String> startTagAttributes(String startTag) {
        String attrs = startTag.substring(startTag.indexOf(91) + 1, startTag.indexOf(93));
        Set set = StringUtils.commaDelimitedListToSet((String)attrs);
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        set.forEach(attr -> {
            String[] keyValue = attr.split("=");
            attributes.put(keyValue[0].trim(), keyValue.length == 2 ? keyValue[1].trim() : "");
        });
        return attributes;
    }

    private String niceDescription(ConfigurationMetadataProperty property) {
        if (property.getDescription() == null) {
            if (this.failOnMissingDescription) {
                throw new RuntimeException("Missing description for property " + property.getId());
            }
            return "<documentation missing>";
        }
        return property.getDescription();
    }

    private CharSequence maybeHints(ConfigurationMetadataProperty property, ClassLoader classLoader) {
        Class clazz;
        String type = property.getType();
        if (type == null) {
            return "";
        }
        if (ClassUtils.isPresent((String)(type = type.replace('$', '.')), (ClassLoader)classLoader) && (clazz = ClassUtils.resolveClassName((String)type, (ClassLoader)classLoader)).isEnum()) {
            return ", possible values: `" + StringUtils.arrayToDelimitedString((Object[])clazz.getEnumConstants(), (String)"`,`") + "`";
        }
        return "";
    }

    private String niceDefault(ConfigurationMetadataProperty property) {
        if (property.getDefaultValue() == null) {
            return "<none>";
        }
        if ("".equals(property.getDefaultValue())) {
            return "<empty string>";
        }
        return this.stringify(property.getDefaultValue());
    }

    private String stringify(Object element) {
        Class<?> clazz = element.getClass();
        if (clazz == byte[].class) {
            return Arrays.toString((byte[])element);
        }
        if (clazz == short[].class) {
            return Arrays.toString((short[])element);
        }
        if (clazz == int[].class) {
            return Arrays.toString((int[])element);
        }
        if (clazz == long[].class) {
            return Arrays.toString((long[])element);
        }
        if (clazz == char[].class) {
            return Arrays.toString((char[])element);
        }
        if (clazz == float[].class) {
            return Arrays.toString((float[])element);
        }
        if (clazz == double[].class) {
            return Arrays.toString((double[])element);
        }
        if (clazz == boolean[].class) {
            return Arrays.toString((boolean[])element);
        }
        if (element instanceof Object[]) {
            return Arrays.deepToString((Object[])element);
        }
        return element.toString();
    }

    private String niceType(ConfigurationMetadataProperty property) {
        String type = property.getType();
        if (type == null) {
            return "<unknown>";
        }
        return this.niceType(type);
    }

    String niceType(String type) {
        ArrayList<String> parts = new ArrayList<String>();
        int openBrackets = 0;
        int lastGenericPart = 0;
        block6: for (int i = 0; i < type.length(); ++i) {
            switch (type.charAt(i)) {
                case '<': {
                    if (openBrackets++ != 0) continue block6;
                    parts.add(type.substring(0, i));
                    lastGenericPart = i + 1;
                    continue block6;
                }
                case '>': {
                    if (--openBrackets != 0) continue block6;
                    parts.add(type.substring(lastGenericPart, i));
                    continue block6;
                }
                case ',': {
                    if (openBrackets != 1) continue block6;
                    parts.add(type.substring(lastGenericPart, i));
                    lastGenericPart = i + 1;
                    continue block6;
                }
                case ' ': {
                    if (openBrackets != 1) continue block6;
                    ++lastGenericPart;
                }
            }
        }
        if (parts.isEmpty()) {
            return this.unqualify(type);
        }
        StringBuilder sb = new StringBuilder(this.unqualify((String)parts.get(0)));
        for (int i = 1; i < parts.size(); ++i) {
            if (i == 1) {
                sb.append('<');
            }
            sb.append(this.unqualify(this.niceType((String)parts.get(i))));
            if (i == parts.size() - 1) {
                sb.append('>');
                continue;
            }
            sb.append(", ");
        }
        return sb.toString();
    }

    private String unqualify(String type) {
        int lastDot = type.lastIndexOf(46);
        int lastDollar = type.lastIndexOf(36);
        return type.substring(Math.max(lastDot, lastDollar) + 1);
    }

    private static final class ScatteredArchive
    implements Archive {
        private final MavenProject mavenProject;

        private ScatteredArchive(MavenProject mavenProject) {
            this.mavenProject = mavenProject;
        }

        public URL getUrl() throws MalformedURLException {
            return this.mavenProject.getArtifact().getFile().toURI().toURL();
        }

        public Manifest getManifest() {
            throw new UnsupportedOperationException();
        }

        public Iterator<Archive> getNestedArchives(Archive.EntryFilter ignored, Archive.EntryFilter ignored2) throws IOException {
            try {
                ArrayList<ExplodedArchive> archives = new ArrayList<ExplodedArchive>(this.mavenProject.getRuntimeClasspathElements().size());
                for (String dep : this.mavenProject.getRuntimeClasspathElements()) {
                    File file = new File(dep);
                    archives.add((ExplodedArchive)(file.isDirectory() ? new ExplodedArchive(file) : new JarFileArchive(file)));
                }
                return archives.iterator();
            }
            catch (DependencyResolutionRequiredException e) {
                throw new IOException("Could not create boot archive", e);
            }
        }

        public Iterator<Archive.Entry> iterator() {
            return Collections.emptyIterator();
        }
    }
}

