/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.http;

import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.contract.verifier.http.Body;

public class Response {
    private final int statusCode;
    private final Body body;
    private final Map<String, Object> headers;
    private final Map<String, Object> cookies;

    Response(int statusCode, Body body, Map<String, Object> headers, Map<String, Object> cookies) {
        this.statusCode = statusCode;
        this.body = body;
        this.headers = headers;
        this.cookies = cookies;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String header(String key) {
        return this.headers.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(key)).findFirst().map(e -> e.getValue().toString()).orElse(null);
    }

    public String cookie(String key) {
        return this.cookies.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(key)).findFirst().map(e -> e.getValue().toString()).orElse(null);
    }

    public Body getBody() {
        return this.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Object> headers() {
        return this.headers;
    }

    public Map<String, Object> cookies() {
        return this.cookies;
    }

    public static Builder from(Response response) {
        return new Builder().headers(response.headers).statusCode(response.statusCode).cookies(response.cookies).body(response.body);
    }

    public static class Builder {
        int statusCode;
        Body body;
        Map<String, Object> headers = new HashMap<String, Object>();
        Map<String, Object> cookies = new HashMap<String, Object>();

        public Builder statusCode(int status) {
            this.statusCode = status;
            return this;
        }

        public Builder body(Object body) {
            this.body = new Body(body);
            return this;
        }

        public Builder headers(Map<String, Object> headers) {
            this.headers = headers;
            return this;
        }

        public Builder header(String key, Object value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder cookie(String key, Object value) {
            this.cookies.put(key, value);
            return this;
        }

        public Builder cookies(Map<String, Object> cookies) {
            this.cookies = cookies;
            return this;
        }

        public Response build() {
            return new Response(this.statusCode, this.body, this.headers, this.cookies);
        }
    }
}

