/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodVisitor;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.GenericBinaryBodyThen;
import org.springframework.cloud.contract.verifier.builder.GenericJsonBodyThen;
import org.springframework.cloud.contract.verifier.builder.GenericTextBodyThen;
import org.springframework.cloud.contract.verifier.builder.GenericXmlBodyThen;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class MessagingBodyThen
implements Then,
BodyMethodVisitor {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final ComparisonBuilder comparisonBuilder;
    private final List<Then> thens = new LinkedList<Then>();
    private final BodyParser bodyParser;

    MessagingBodyThen(BlockBuilder blockBuilder, GeneratedClassMetaData metaData, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = metaData;
        this.comparisonBuilder = comparisonBuilder;
        this.bodyParser = comparisonBuilder.bodyParser();
        this.thens.addAll(Arrays.asList(new GenericBinaryBodyThen(blockBuilder, metaData, this.bodyParser, this.comparisonBuilder), new GenericTextBodyThen(blockBuilder, metaData, this.bodyParser, this.comparisonBuilder), new GenericJsonBodyThen(blockBuilder, metaData, this.bodyParser, this.comparisonBuilder), new GenericXmlBodyThen(blockBuilder, this.bodyParser)));
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata singleContractMetadata) {
        this.endBodyBlock(this.blockBuilder);
        this.startBodyBlock(this.blockBuilder, "and:");
        this.thens.stream().filter(then -> then.accept(singleContractMetadata)).forEach(then -> then.apply(singleContractMetadata));
        return this;
    }

    @Override
    public boolean accept(SingleContractMetadata singleContractMetadata) {
        return singleContractMetadata.isMessaging() && this.bodyParser.responseBody(singleContractMetadata) != null;
    }
}

