/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.verifier.util.ContractScanner;

public final class ToFileContractsTransformer {
    private static final Logger log = LoggerFactory.getLogger(ToFileContractsTransformer.class);

    public static void main(String[] args) {
        if (args.length == 0) {
            throw new IllegalStateException(ToFileContractsTransformer.exceptionMessage());
        }
        log.warn("You're using an incubating feature. Note, that it can be changed / removed in the future");
        String fqn = args[0];
        String outputPath = args.length >= 2 ? args[1] : "target/converted-contracts";
        String path = args.length >= 3 ? args[2] : "src/test/resources/contracts";
        new ToFileContractsTransformer().storeContractsAsFiles(path, fqn, outputPath);
    }

    private static String exceptionMessage() {
        return "Please provide the FQN of the ContractConverter. E.g. [org.springframework.cloud.contract.verifier.converter.YamlContractConverter]";
    }

    List<File> storeContractsAsFiles(String path, String fqn, String outputPath) {
        try {
            log.info("Input path [{}]", (Object)path);
            log.info("FQN of the converter [{}]", (Object)fqn);
            log.info("Output path [{}]", (Object)outputPath);
            Collection<Contract> contracts = ContractScanner.collectContractDescriptors(new File(path));
            log.info("Found [{}] contract definition", (Object)contracts.size());
            Class<?> name = Class.forName(fqn);
            ContractConverter contractConverter = (ContractConverter)name.getDeclaredConstructors()[0].newInstance(new Object[0]);
            Collection converted = (Collection)contractConverter.convertTo(contracts);
            log.info("Successfully converted contracts definitions");
            Map stored = contractConverter.store((Object)converted);
            File outputFolder = new File(outputPath);
            outputFolder.mkdirs();
            int i = 1;
            Set entries = stored.entrySet();
            log.info("Will convert [{}] contracts", (Object)entries.size());
            ArrayList<File> files = new ArrayList<File>();
            for (Map.Entry entry : entries) {
                File outputFile = new File(outputFolder, (String)entry.getKey());
                Files.write(outputFile.toPath(), (byte[])entry.getValue(), new OpenOption[0]);
                log.info("[{}/{}] Successfully stored [{}]", new Object[]{i, entries.size(), outputFile.getName()});
                files.add(outputFile);
            }
            return files;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

