/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

interface BodyMethodVisitor {
    default public BlockBuilder startBodyBlock(BlockBuilder blockBuilder, String label) {
        return blockBuilder.addIndentation().appendWithLabelPrefix(label).addEmptyLine().startBlock();
    }

    default public void indentedBodyBlock(BlockBuilder blockBuilder, List<? extends MethodVisitor> methodVisitors, SingleContractMetadata singleContractMetadata) {
        List<MethodVisitor> visitors = this.filterVisitors(methodVisitors, singleContractMetadata);
        if (visitors.isEmpty()) {
            blockBuilder.addEndingIfNotPresent().addEmptyLine();
            blockBuilder.endBlock();
            return;
        }
        blockBuilder.addEmptyLine().indent();
        this.applyVisitors(blockBuilder, singleContractMetadata, visitors);
        this.endIndentedBodyBlock(blockBuilder);
    }

    default public List<MethodVisitor> filterVisitors(List<? extends MethodVisitor> methodVisitors, SingleContractMetadata singleContractMetadata) {
        return methodVisitors.stream().filter(given -> given.accept(singleContractMetadata)).collect(Collectors.toList());
    }

    default public void bodyBlock(BlockBuilder blockBuilder, List<? extends MethodVisitor> methodVisitors, SingleContractMetadata singleContractMetadata) {
        List<MethodVisitor> visitors = this.filterVisitors(methodVisitors, singleContractMetadata);
        if (visitors.isEmpty()) {
            blockBuilder.addEndingIfNotPresent().addEmptyLine();
            return;
        }
        this.applyVisitorsWithEnding(blockBuilder, singleContractMetadata, visitors);
        this.endBodyBlock(blockBuilder);
    }

    default public void applyVisitors(BlockBuilder blockBuilder, SingleContractMetadata singleContractMetadata, List<MethodVisitor> visitors) {
        Iterator<MethodVisitor> iterator = visitors.iterator();
        while (iterator.hasNext()) {
            MethodVisitor visitor = iterator.next();
            visitor.apply(singleContractMetadata);
            if (!iterator.hasNext()) continue;
            blockBuilder.addEmptyLine();
        }
        blockBuilder.addEndingIfNotPresent();
    }

    default public void applyVisitorsWithEnding(BlockBuilder blockBuilder, SingleContractMetadata singleContractMetadata, List<MethodVisitor> visitors) {
        Iterator<MethodVisitor> iterator = visitors.iterator();
        while (iterator.hasNext()) {
            MethodVisitor visitor = iterator.next();
            visitor.apply(singleContractMetadata);
            blockBuilder.addEndingIfNotPresent();
            if (!iterator.hasNext()) continue;
            blockBuilder.addEmptyLine();
        }
    }

    default public void endIndentedBodyBlock(BlockBuilder blockBuilder) {
        blockBuilder.addEndingIfNotPresent().unindent().endBlock();
    }

    default public void endBodyBlock(BlockBuilder blockBuilder) {
        blockBuilder.addEndingIfNotPresent().endBlock();
    }
}

