/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.OutputMessage;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodVisitor;
import org.springframework.cloud.contract.verifier.builder.BodyReader;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class MessagingReceiveMessageThen
implements Then,
BodyMethodVisitor {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final ComparisonBuilder comparisonBuilder;
    private final BodyReader bodyReader;

    MessagingReceiveMessageThen(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
        this.comparisonBuilder = comparisonBuilder;
        this.bodyReader = new BodyReader(generatedClassMetaData);
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata singleContractMetadata) {
        OutputMessage outputMessage = singleContractMetadata.getContract().getOutputMessage();
        this.bodyReader.storeContractAsYaml(singleContractMetadata);
        this.blockBuilder.addIndented("ContractVerifierMessage response = contractVerifierMessaging.receive(" + this.sentToValue(outputMessage.getSentTo().getServerValue()) + ",").addEmptyLine().indent().addIndented("contract(this, \"" + singleContractMetadata.methodName() + ".yml\"))").unindent().addEndingIfNotPresent().addEmptyLine();
        this.blockBuilder.addLineWithEnding(this.comparisonBuilder.assertThatIsNotNull("response"));
        return this;
    }

    private String sentToValue(Object sentTo) {
        if (sentTo instanceof ExecutionProperty) {
            return ((ExecutionProperty)sentTo).getExecutionCommand();
        }
        return "\"" + sentTo.toString() + "\"";
    }

    @Override
    public boolean accept(SingleContractMetadata singleContractMetadata) {
        return singleContractMetadata.isMessaging() && singleContractMetadata.getContract().getOutputMessage().getSentTo() != null;
    }
}

