/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.jms;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.jms.ReplyToProcessor;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessagePostProcessor;

class JmsStubMessages
implements MessageVerifier<Message> {
    private final JmsTemplate jmsTemplate;

    JmsStubMessages(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    @Override
    public void send(Message message, String destination, YamlContract contract) {
        this.jmsTemplate.convertAndSend(destination, (Object)message, (MessagePostProcessor)new ReplyToProcessor());
    }

    @Override
    public Message receive(String destination, long timeout, TimeUnit timeUnit, YamlContract contract) {
        this.jmsTemplate.setReceiveTimeout(timeUnit.toMillis(timeout));
        return this.jmsTemplate.receive(destination);
    }

    @Override
    public Message receive(String destination, YamlContract contract) {
        return this.receive(destination, 5L, TimeUnit.SECONDS, contract);
    }

    @Override
    public void send(Object payload, Map headers, String destination, YamlContract contract) {
        this.jmsTemplate.send(destination, session -> {
            Message message = this.createMessage(session, payload);
            this.setHeaders(message, headers == null ? Collections.emptyMap() : headers);
            return message;
        });
    }

    private Message createMessage(Session session, Object payload) throws JMSException {
        if (payload instanceof String) {
            return session.createTextMessage((String)payload);
        }
        if (payload instanceof byte[]) {
            BytesMessage bytesMessage = session.createBytesMessage();
            bytesMessage.writeBytes((byte[])payload);
            return bytesMessage;
        }
        if (payload instanceof Serializable) {
            return session.createObjectMessage((Serializable)payload);
        }
        return session.createMessage();
    }

    private void setHeaders(Message message, Map<String, Object> headers) {
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            try {
                if (value instanceof String) {
                    message.setStringProperty(key, (String)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    message.setBooleanProperty(key, ((Boolean)value).booleanValue());
                    continue;
                }
                message.setObjectProperty(key, value);
            }
            catch (JMSException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

