/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import groovy.json.JsonOutput;
import groovy.lang.Closure;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractTemplate;
import org.springframework.cloud.contract.spec.internal.BodyMatcher;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.MatchingType;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodGeneration;
import org.springframework.cloud.contract.verifier.builder.ClassVerifier;
import org.springframework.cloud.contract.verifier.builder.TestSideRequestTemplateModel;
import org.springframework.cloud.contract.verifier.template.TemplateProcessor;
import org.springframework.cloud.contract.verifier.util.JsonPaths;
import org.springframework.cloud.contract.verifier.util.JsonToJsonPathsConverter;
import org.springframework.cloud.contract.verifier.util.MapConverter;

class JsonBodyVerificationBuilder
implements BodyMethodGeneration,
ClassVerifier {
    private static final String FROM_REQUEST_PREFIX = "request.";
    private static final String FROM_REQUEST_BODY = "escapejsonbody";
    private static final String FROM_REQUEST_PATH = "path";
    private final boolean assertJsonSize;
    private final TemplateProcessor templateProcessor;
    private final ContractTemplate contractTemplate;
    private final Contract contract;
    private final Optional<String> lineSuffix;
    private final Function<String, String> postProcessJsonPathCall;

    JsonBodyVerificationBuilder(boolean assertJsonSize, TemplateProcessor templateProcessor, ContractTemplate contractTemplate, Contract contract, Optional<String> lineSuffix, Function<String, String> postProcessJsonPathCall) {
        this.assertJsonSize = assertJsonSize;
        this.templateProcessor = templateProcessor;
        this.contractTemplate = contractTemplate;
        this.contract = contract;
        this.lineSuffix = lineSuffix;
        this.postProcessJsonPathCall = postProcessJsonPathCall;
    }

    Object addJsonResponseBodyCheck(BlockBuilder bb, Object convertedResponseBody, BodyMatchers bodyMatchers, String responseString, boolean shouldCommentOutBDDBlocks) {
        Closure parsingClosure;
        this.appendJsonPath(bb, responseString);
        DocumentContext parsedRequestBody = null;
        boolean dontParseStrings = convertedResponseBody instanceof Map;
        Closure closure = parsingClosure = dontParseStrings ? Closure.IDENTITY : MapConverter.JSON_PARSING_CLOSURE;
        if (this.hasRequestBody()) {
            Object testSideRequestBody = MapConverter.getTestSideValues((Object)this.contract.getRequest().getBody(), parsingClosure);
            parsedRequestBody = JsonPath.parse((Object)testSideRequestBody);
            if (convertedResponseBody instanceof String && !this.textContainsJsonPathTemplate(convertedResponseBody.toString())) {
                convertedResponseBody = this.templateProcessor.transform(this.contract.getRequest(), convertedResponseBody.toString());
            }
        }
        Object copiedBody = this.cloneBody(convertedResponseBody);
        convertedResponseBody = JsonToJsonPathsConverter.removeMatchingJsonPaths(convertedResponseBody, bodyMatchers);
        TestSideRequestTemplateModel templateModel = this.hasRequestBody() ? TestSideRequestTemplateModel.from(this.contract.getRequest()) : null;
        convertedResponseBody = MapConverter.transformValues(convertedResponseBody, this.returnReferencedEntries(templateModel), parsingClosure);
        JsonPaths jsonPaths = new JsonToJsonPathsConverter(this.assertJsonSize).transformToJsonPathWithTestsSideValues(convertedResponseBody, parsingClosure);
        DocumentContext finalParsedRequestBody = parsedRequestBody;
        jsonPaths.forEach(it -> {
            String method = it.method();
            String postProcessedMethod = this.templateProcessor.containsJsonPathTemplateEntry(method = this.processIfTemplateIsPresent(method, finalParsedRequestBody)) ? method : this.postProcessJsonPathCall.apply(method);
            bb.addLine("assertThatJson(parsedJson)" + postProcessedMethod);
            this.addColonIfRequired(this.lineSuffix, bb);
        });
        this.doBodyMatchingIfPresent(bodyMatchers, bb, copiedBody, shouldCommentOutBDDBlocks);
        return convertedResponseBody;
    }

    private boolean hasRequestBody() {
        return this.contract.getRequest() != null && this.contract.getRequest().getBody() != null;
    }

    private void checkType(BlockBuilder bb, BodyMatcher it, Object elementFromBody) {
        String method = "assertThat((Object) parsedJson.read(" + this.quotedAndEscaped(it.path()) + ")).isInstanceOf(" + this.classToCheck(elementFromBody).getName() + ".class)";
        bb.addLine(this.postProcessJsonPathCall.apply(method));
        this.addColonIfRequired(this.lineSuffix, bb);
    }

    private String sizeCheckMethod(BodyMatcher bodyMatcher, String quotedAndEscaptedPath) {
        String prefix = this.sizeCheckPrefix(bodyMatcher, quotedAndEscaptedPath);
        if (bodyMatcher.minTypeOccurrence() != null && bodyMatcher.maxTypeOccurrence() != null) {
            return prefix + "Between(" + bodyMatcher.minTypeOccurrence() + ", " + bodyMatcher.maxTypeOccurrence() + ")";
        }
        if (bodyMatcher.minTypeOccurrence() != null) {
            return prefix + "GreaterThanOrEqualTo(" + bodyMatcher.minTypeOccurrence() + ")";
        }
        if (bodyMatcher.maxTypeOccurrence() != null) {
            return prefix + "LessThanOrEqualTo(" + bodyMatcher.maxTypeOccurrence() + ")";
        }
        return prefix;
    }

    protected void buildCustomMatchingConditionForEachElement(BlockBuilder bb, String path, String valueAsParam) {
        String method = "assertThat((java.lang.Iterable) parsedJson.read(" + path + ", java.util.Collection.class)).as(" + path + ").allElementsMatch(" + valueAsParam + ")";
        bb.addLine(this.postProcessJsonPathCall.apply(method));
    }

    @Override
    public void methodForEqualityCheck(BodyMatcher bodyMatcher, BlockBuilder bb, Object copiedBody) {
        String valueAsParam;
        String path = this.quotedAndEscaped(bodyMatcher.path());
        Object retrievedValue = JsonBodyVerificationBuilder.value(copiedBody, bodyMatcher);
        retrievedValue = retrievedValue instanceof RegexProperty ? ((RegexProperty)retrievedValue).getPattern().pattern() : retrievedValue;
        String string = valueAsParam = retrievedValue instanceof String ? this.quotedAndEscaped(retrievedValue.toString()) : this.objectToString(retrievedValue);
        if (this.arrayRelated(path) && MatchingType.regexRelated((MatchingType)bodyMatcher.matchingType())) {
            this.buildCustomMatchingConditionForEachElement(bb, path, valueAsParam);
        } else {
            String comparisonMethod = bodyMatcher.matchingType() == MatchingType.EQUALITY ? "isEqualTo" : "matches";
            String classToCastTo = this.className(retrievedValue) + ".class";
            String method = "assertThat(parsedJson.read(" + path + ", " + classToCastTo + "))." + comparisonMethod + "(" + valueAsParam + ")";
            bb.addLine(this.postProcessJsonPathCall.apply(method));
        }
        this.addColonIfRequired(this.lineSuffix, bb);
    }

    private String className(Object retrievedValue) {
        return retrievedValue.getClass().getName().startsWith("java.lang") ? retrievedValue.getClass().getSimpleName() : retrievedValue.getClass().getName();
    }

    private String objectToString(Object value) {
        if (value instanceof Long) {
            return String.valueOf(value).concat("L");
        }
        if (value instanceof Double) {
            return String.valueOf(value).concat("D");
        }
        if (value instanceof BigDecimal) {
            return this.quotedAndEscaped(value.toString());
        }
        return String.valueOf(value);
    }

    protected String processIfTemplateIsPresent(String method, DocumentContext parsedRequestBody) {
        String jsonPathEntry;
        Object object;
        if (this.textContainsJsonPathTemplate(method) && this.hasRequestBody() && !((object = parsedRequestBody.read(jsonPathEntry = this.templateProcessor.jsonPathFromTemplateEntry(method), new Predicate[0])) instanceof String)) {
            return method.replace('\"' + this.contractTemplate.escapedOpeningTemplate(), this.contractTemplate.escapedOpeningTemplate()).replace(this.contractTemplate.escapedClosingTemplate() + '\"', this.contractTemplate.escapedClosingTemplate()).replace('\"' + this.contractTemplate.openingTemplate(), this.contractTemplate.openingTemplate()).replace(this.contractTemplate.closingTemplate() + '\"', this.contractTemplate.closingTemplate());
        }
        return method;
    }

    @Override
    public void methodForCommandExecution(BodyMatcher bodyMatcher, BlockBuilder bb, Object copiedBody) {
        String path = this.quotedAndEscaped(bodyMatcher.path());
        JsonBodyVerificationBuilder.retrieveObjectByPath(copiedBody, bodyMatcher.path());
        ExecutionProperty property = (ExecutionProperty)bodyMatcher.value();
        bb.addLine(this.postProcessJsonPathCall.apply(property.insertValue("parsedJson.read(" + path + ")")));
        this.addColonIfRequired(this.lineSuffix, bb);
    }

    @Override
    public void methodForNullCheck(BodyMatcher bodyMatcher, BlockBuilder bb) {
        String quotedAndEscapedPath = this.quotedAndEscaped(bodyMatcher.path());
        String method = "assertThat((Object) parsedJson.read(" + quotedAndEscapedPath + ")).isNull()";
        bb.addLine(this.postProcessJsonPathCall.apply(method));
        this.addColonIfRequired(this.lineSuffix, bb);
    }

    private boolean arrayRelated(String path) {
        return path.contains("[*]") || path.contains("..");
    }

    @Override
    public void methodForTypeCheck(BodyMatcher bodyMatcher, BlockBuilder bb, Object copiedBody) {
        Object elementFromBody = JsonBodyVerificationBuilder.value(copiedBody, bodyMatcher);
        if (bodyMatcher.minTypeOccurrence() != null || bodyMatcher.maxTypeOccurrence() != null) {
            this.checkType(bb, bodyMatcher, elementFromBody);
            String quotedAndEscaptedPath = this.quotedAndEscaped(bodyMatcher.path());
            String method = "assertThat((java.lang.Iterable) parsedJson.read(" + quotedAndEscaptedPath + ", java.util.Collection.class))." + this.sizeCheckMethod(bodyMatcher, quotedAndEscaptedPath);
            bb.addLine(this.postProcessJsonPathCall.apply(method));
            this.addColonIfRequired(this.lineSuffix, bb);
        } else {
            this.checkType(bb, bodyMatcher, elementFromBody);
        }
    }

    private static Object value(Object body, BodyMatcher bodyMatcher) {
        if (bodyMatcher.matchingType() == MatchingType.EQUALITY || bodyMatcher.value() == null) {
            return JsonBodyVerificationBuilder.retrieveObjectByPath(body, bodyMatcher.path());
        }
        return bodyMatcher.value();
    }

    private static Object retrieveObjectByPath(Object body, String path) {
        try {
            return JsonPath.parse((Object)body).read(path, new Predicate[0]);
        }
        catch (PathNotFoundException e) {
            throw new IllegalStateException("Entry for the provided JSON path <" + path + "> doesn't exist in the body <" + JsonOutput.toJson((Object)body) + ">", e);
        }
    }

    private Closure<Object> returnReferencedEntries(TestSideRequestTemplateModel templateModel) {
        return MapConverter.fromFunction(entry -> {
            if (!(entry instanceof String) || templateModel == null) {
                return entry;
            }
            String entryAsString = (String)entry;
            if (this.templateProcessor.containsTemplateEntry(entryAsString) && !this.templateProcessor.containsJsonPathTemplateEntry(entryAsString)) {
                String justEntry = JsonBodyVerificationBuilder.minus(entryAsString, this.contractTemplate.escapedOpeningTemplate());
                justEntry = JsonBodyVerificationBuilder.minus(justEntry, this.contractTemplate.openingTemplate());
                justEntry = JsonBodyVerificationBuilder.minus(justEntry, this.contractTemplate.escapedClosingTemplate());
                justEntry = JsonBodyVerificationBuilder.minus(justEntry, this.contractTemplate.closingTemplate());
                if (FROM_REQUEST_BODY.equalsIgnoreCase(justEntry = JsonBodyVerificationBuilder.minus(justEntry, FROM_REQUEST_PREFIX))) {
                    return this.contractTemplate.escapedOpeningTemplate() + FROM_REQUEST_PREFIX + "escapedBody" + this.contractTemplate.escapedClosingTemplate();
                }
                try {
                    Object result = new PropertyUtilsBean().getProperty((Object)templateModel, justEntry);
                    if (FROM_REQUEST_PATH.equals(justEntry)) {
                        return result.toString();
                    }
                    return result;
                }
                catch (Exception ignored) {
                    return entry;
                }
            }
            return entry;
        });
    }

    private static String minus(CharSequence self, Object target) {
        String text;
        String s = self.toString();
        int index = s.indexOf(text = target.toString());
        if (index == -1) {
            return s;
        }
        int end = index + text.length();
        if (s.length() > end) {
            return s.substring(0, index) + s.substring(end);
        }
        return s.substring(0, index);
    }

    private boolean textContainsJsonPathTemplate(String method) {
        return this.templateProcessor.containsTemplateEntry(method) && this.templateProcessor.containsJsonPathTemplateEntry(method);
    }

    private void appendJsonPath(BlockBuilder blockBuilder, String json) {
        blockBuilder.addLine("DocumentContext parsedJson = JsonPath.parse(" + json + ")");
        this.addColonIfRequired(this.lineSuffix, blockBuilder);
    }

    private String sizeCheckPrefix(BodyMatcher bodyMatcher, String quotedAndEscapedPath) {
        String description = "as(" + quotedAndEscapedPath + ").";
        String prefix = description + "has";
        if (this.arrayRelated(bodyMatcher.path())) {
            prefix = prefix + "Flattened";
        }
        return prefix + "Size";
    }

    private void doBodyMatchingIfPresent(BodyMatchers bodyMatchers, BlockBuilder bb, Object responseBody, boolean shouldCommentOutBDDBlocks) {
        if (bodyMatchers != null && bodyMatchers.hasMatchers()) {
            bb.addEmptyLine();
            this.addBodyMatchingBlock(bodyMatchers.matchers(), bb, responseBody, shouldCommentOutBDDBlocks);
        }
    }
}

