/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.util.NamesUtil;
import org.springframework.util.StringUtils;

class BaseClassProvider {
    private static final Log log = LogFactory.getLog(BaseClassProvider.class);
    private static final String SEPARATOR = "_REPLACEME_";

    BaseClassProvider() {
    }

    String retrieveBaseClass(Map<String, String> baseClassMappings, String packageWithBaseClasses, String baseClassForTests, String includedDirectoryRelativePath) {
        String contractPathAsPackage = includedDirectoryRelativePath.replace(File.separator, ".");
        String contractPackage = includedDirectoryRelativePath.replace(File.separator, SEPARATOR);
        if (baseClassMappings != null && !baseClassMappings.isEmpty()) {
            Optional<Map.Entry> mapping = baseClassMappings.entrySet().stream().filter(entry -> {
                String pattern = (String)entry.getKey();
                return contractPathAsPackage.matches(pattern);
            }).findFirst();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Matching pattern for contract package [" + contractPathAsPackage + "] with setup " + baseClassMappings + " is [" + mapping + "]"));
            }
            if (mapping.isPresent()) {
                return (String)mapping.get().getValue();
            }
        }
        if (StringUtils.isEmpty((Object)packageWithBaseClasses)) {
            return baseClassForTests;
        }
        String generatedClassName = this.generateDefaultBaseClassName(contractPackage, packageWithBaseClasses);
        return generatedClassName + "Base";
    }

    private String generateDefaultBaseClassName(String classPackage, String packageWithBaseClasses) {
        String[] splitPackage = NamesUtil.convertIllegalPackageChars(classPackage).split(SEPARATOR);
        if (splitPackage.length > 1) {
            String last = NamesUtil.capitalize(splitPackage[splitPackage.length - 1]);
            String butLast = NamesUtil.capitalize(splitPackage[splitPackage.length - 2]);
            return packageWithBaseClasses + "." + butLast + last;
        }
        return packageWithBaseClasses + "." + NamesUtil.capitalize(splitPackage[0]);
    }
}

