/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.verifier.util.ContractScanner;

public final class ToFileContractsTransformer
implements GroovyObject {
    private static final Log log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public ToFileContractsTransformer() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static void main(String ... args) {
        if (args.length == 0) {
            throw (Throwable)new IllegalStateException(ToFileContractsTransformer.exceptionMessage());
        }
        log.warn((Object)"You're using an incubating feature. Note, that it can be changed / removed in the future");
        String fqn = ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])args, (int)0));
        String outputPath = args.length >= 2 ? ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])args, (int)1)) : "target/converted-contracts";
        String path = args.length >= 3 ? ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])args, (int)2)) : "src/test/resources/contracts";
        new ToFileContractsTransformer().storeContractsAsFiles(path, fqn, outputPath);
    }

    private static String exceptionMessage() {
        return "Please provide the FQN of the ContractConverter. E.g. [org.springframework.cloud.contract.verifier.converter.YamlContractConverter]";
    }

    public final List<File> storeContractsAsFiles(String path, String fqn, String outputPath) {
        log.info((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Input path [", (CharSequence)path), (CharSequence)"]"));
        log.info((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"FQN of the converter [", (CharSequence)fqn), (CharSequence)"]"));
        log.info((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Output path [", (CharSequence)outputPath), (CharSequence)"]"));
        Collection<Contract> contracts = ContractScanner.collectContractDescriptors(new File(path));
        log.info((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Found [", (Object)contracts.size()), (CharSequence)"] contract definition"));
        Class<?> name = Class.forName(fqn);
        ContractConverter contractConverter = (ContractConverter)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.newInstance(name), ContractConverter.class);
        Collection converted = (Collection)ScriptBytecodeAdapter.castToType((Object)contractConverter.convertTo(contracts), Collection.class);
        log.info((Object)"Successfully converted contracts definitions");
        Map stored = contractConverter.store((Object)converted);
        File outputFolder = new File(outputPath);
        outputFolder.mkdirs();
        int i = 1;
        Set entries = stored.entrySet();
        log.info((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Will convert [", (Object)entries.size()), (CharSequence)"] contracts"));
        ArrayList<File> files = new ArrayList<File>();
        Map.Entry entry = null;
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
            File outputFile = new File(outputFolder, ShortTypeHandling.castToString(entry.getKey()));
            Files.write(outputFile.toPath(), (byte[])ScriptBytecodeAdapter.castToType(entry.getValue(), byte[].class), new OpenOption[0]);
            log.info((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"[", (Object)i), (CharSequence)"/"), (Object)entries.size()), (CharSequence)"] Successfully stored ["), (CharSequence)outputFile.getName()), (CharSequence)"]"));
            files.add(outputFile);
        }
        ArrayList<File> arrayList = files;
        try {
            return arrayList;
        }
        catch (Exception ex) {
            throw (Throwable)new IllegalStateException(ex);
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ToFileContractsTransformer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Log log;
        ToFileContractsTransformer.log = log = LogFactory.getLog(ToFileContractsTransformer.class);
    }
}

