/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.stream;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;
import org.springframework.cloud.contract.verifier.messaging.stream.ContractVerifierStreamMessageBuilder;
import org.springframework.cloud.stream.binder.test.InputDestination;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.util.StringUtils;

class StreamInputDestinationMessageSender
implements MessageVerifierSender<Message<?>> {
    private static final Log log = LogFactory.getLog(StreamInputDestinationMessageSender.class);
    private final ApplicationContext context;
    private final ContractVerifierStreamMessageBuilder builder = new ContractVerifierStreamMessageBuilder();

    StreamInputDestinationMessageSender(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public <T> void send(T payload, Map<String, Object> headers, String destination) {
        this.send(this.builder.create(payload, headers), destination);
    }

    @Override
    public void send(Message<?> message, String destination) {
        try {
            InputDestination inputDestination = (InputDestination)this.context.getBean(InputDestination.class);
            StreamFunctionProperties streamFunctionProperties = (StreamFunctionProperties)this.context.getBean(StreamFunctionProperties.class);
            int indexOfDestination = StringUtils.isEmpty((Object)streamFunctionProperties.getDefinition()) ? 0 : this.indexOfDestination(streamFunctionProperties, destination);
            inputDestination.send(message, indexOfDestination);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while trying to send a message [" + message + "] to a destination with name [" + destination + "]"), (Throwable)e);
            throw e;
        }
    }

    private int indexOfDestination(StreamFunctionProperties streamFunctionProperties, String destination) {
        String[] split = streamFunctionProperties.getDefinition().split(";");
        int indexOfDestination = Arrays.stream(split).map(String::toLowerCase).collect(Collectors.toList()).indexOf(destination.toLowerCase());
        if (indexOfDestination == -1) {
            throw new IllegalStateException("Destination with name [" + destination + "] not found in the function definitions [" + streamFunctionProperties.getDefinition() + "]");
        }
        return indexOfDestination;
    }
}

