/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import groovy.json.JsonOutput;
import groovy.lang.Closure;
import groovy.lang.GString;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.verifier.builder.BodyThen;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.ContentType;
import org.springframework.cloud.contract.verifier.util.ContentUtils;
import org.springframework.cloud.contract.verifier.util.MapConverter;

interface BodyParser
extends BodyThen {
    public String byteArrayString();

    default public String convertUnicodeEscapesIfRequired(String json) {
        String unescapedJson = StringEscapeUtils.unescapeEcmaScript((String)json);
        return StringEscapeUtils.escapeJava((String)unescapedJson);
    }

    default public String convertToJsonString(Object bodyValue) {
        String json = JsonOutput.toJson((Object)bodyValue);
        json = this.convertUnicodeEscapesIfRequired(json);
        return this.trimRepeatedQuotes(json);
    }

    default public String trimRepeatedQuotes(String toTrim) {
        if (toTrim.startsWith("\"")) {
            return toTrim.replaceAll("\"", "");
        }
        if (toTrim.startsWith("\\\"") && toTrim.endsWith("\\\"")) {
            return toTrim.substring(2, toTrim.length() - 2);
        }
        return toTrim;
    }

    default public Object convertResponseBody(SingleContractMetadata metadata) {
        DslProperty body;
        ContentType contentType = metadata.getOutputTestContentType();
        Object responseBody = this.extractServerValueFromBody(contentType, (body = this.responseBody(metadata)).getServerValue());
        if (responseBody instanceof FromFileProperty) {
            responseBody = ((FromFileProperty)responseBody).asString();
        } else if (responseBody instanceof GString) {
            responseBody = ContentUtils.extractValue((GString)responseBody, contentType, o -> o instanceof DslProperty ? ((DslProperty)o).getServerValue() : o);
        } else if (responseBody instanceof DslProperty) {
            responseBody = MapConverter.getTestSideValues(responseBody);
        }
        return responseBody;
    }

    public String responseAsString();

    default public String requestBodyAsString(SingleContractMetadata metadata) {
        ContentType contentType = metadata.getInputTestContentType();
        DslProperty body = this.requestBody(metadata);
        Object bodyValue = this.extractServerValueFromBody(contentType, body.getServerValue());
        if (contentType == ContentType.FORM) {
            if (bodyValue instanceof Map) {
                return ((Map)bodyValue).entrySet().stream().map(o -> {
                    Map.Entry entry = (Map.Entry)o;
                    return this.convertUnicodeEscapesIfRequired(entry.getKey().toString() + "=" + MapConverter.getTestSideValuesForText(entry.getValue()));
                }).collect(Collectors.joining("&")).toString();
            }
            if (bodyValue instanceof List) {
                return ((List)bodyValue).stream().map(o -> this.convertUnicodeEscapesIfRequired(MapConverter.getTestSideValuesForText(o).toString())).collect(Collectors.joining("&")).toString();
            }
        } else {
            return this.convertToJsonString(bodyValue);
        }
        return "";
    }

    default public Object extractServerValueFromBody(ContentType contentType, Object bodyValue) {
        if (bodyValue instanceof GString) {
            return ContentUtils.extractValue((GString)bodyValue, contentType, ContentUtils.GET_TEST_SIDE);
        }
        if (bodyValue instanceof FromFileProperty) {
            return MapConverter.transformValues(bodyValue, ContentUtils.GET_TEST_SIDE);
        }
        if (ContentType.TEXT != contentType && ContentType.FORM != contentType && ContentType.DEFINED != contentType) {
            boolean dontParseStrings = contentType == ContentType.JSON && bodyValue instanceof Map;
            Closure parsingClosure = dontParseStrings ? Closure.IDENTITY : MapConverter.JSON_PARSING_CLOSURE;
            return MapConverter.getTestSideValues(bodyValue, parsingClosure);
        }
        return bodyValue;
    }

    default public String escape(String text) {
        return StringEscapeUtils.escapeJava((String)text);
    }

    default public String escapeForSimpleTextAssertion(String text) {
        return text;
    }

    default public String postProcessJsonPath(String jsonPath) {
        return jsonPath;
    }

    default public String quotedLongText(Object text) {
        return this.quotedEscapedLongText(this.escape(text.toString()));
    }

    default public String quotedEscapedLongText(Object text) {
        return "\"" + text.toString() + "\"";
    }

    default public String quotedShortText(Object text) {
        return this.quotedLongText(text);
    }

    default public String quotedEscapedShortText(Object text) {
        return this.quotedEscapedLongText(text);
    }
}

