/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.camel;

import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.camel.CamelStubMessages;
import org.springframework.cloud.contract.verifier.messaging.camel.ContractVerifierCamelHelper;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.jms.ContractVerifierJmsConfiguration;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpContractVerifierAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Message.class})
@Import(value={CamelAutoConfiguration.class})
@ConditionalOnProperty(name={"stubrunner.camel.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={NoOpContractVerifierAutoConfiguration.class, ContractVerifierJmsConfiguration.class})
public class ContractVerifierCamelConfiguration {
    @Bean
    @ConditionalOnMissingBean
    MessageVerifier<Message> contractVerifierMessageExchange(CamelContext camelContext) {
        return new CamelStubMessages(camelContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public ContractVerifierMessaging<Message> contractVerifierMessaging(MessageVerifier<Message> exchange) {
        return new ContractVerifierCamelHelper(exchange);
    }
}

