/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.internal.Response;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.MockMvcAcceptor;
import org.springframework.cloud.contract.verifier.builder.When;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class MockMvcAsyncWhen
implements When,
MockMvcAcceptor {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;

    MockMvcAsyncWhen(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    @Override
    public MethodVisitor<When> apply(SingleContractMetadata metadata) {
        Response response = metadata.getContract().getResponse();
        this.addAsync();
        if (response.getDelay() != null) {
            String delay = ".timeout(" + response.getDelay().getServerValue() + ")";
            this.blockBuilder.append(delay);
        }
        return this;
    }

    private void addAsync() {
        this.blockBuilder.addIndented(".when().async()");
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        boolean accept = this.acceptType(this.generatedClassMetaData, metadata);
        if (!accept) {
            return false;
        }
        Response response = metadata.getContract().getResponse();
        return response.getAsync() || response.getDelay() != null;
    }
}

