/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.stream;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpContractVerifierAutoConfiguration;
import org.springframework.cloud.contract.verifier.messaging.stream.ContractVerifierHelper;
import org.springframework.cloud.contract.verifier.messaging.stream.StreamStubMessages;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.test.binder.MessageCollector;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.Message;

@Configuration
@ConditionalOnClass(value={EnableBinding.class, MessageCollector.class})
@ConditionalOnProperty(name={"stubrunner.stream.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={NoOpContractVerifierAutoConfiguration.class})
public class ContractVerifierStreamAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    MessageVerifier<Message<?>> contractVerifierMessageExchange(ApplicationContext applicationContext) {
        return new StreamStubMessages(applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public ContractVerifierMessaging<?> contractVerifierMessagingConverter(MessageVerifier<Message<?>> exchange) {
        return new ContractVerifierHelper(exchange);
    }
}

