/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.assertion;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.assertj.core.api.IterableAssert;

public class CollectionAssert<ELEMENT>
extends IterableAssert<ELEMENT> {
    public CollectionAssert(Iterable<? extends ELEMENT> actual) {
        super(actual);
    }

    public CollectionAssert(Iterator<? extends ELEMENT> actual) {
        super(actual);
    }

    public CollectionAssert allElementsMatch(String regex) {
        this.isNotNull();
        this.isNotEmpty();
        for (Object anActual : (Iterable)this.actual) {
            String value;
            if (anActual == null) {
                this.failWithMessageRelatedToRegex(regex, anActual);
            }
            if ((value = anActual.toString()).matches(regex)) continue;
            this.failWithMessageRelatedToRegex(regex, value);
        }
        return this;
    }

    private void failWithMessageRelatedToRegex(String regex, Object value) {
        this.failWithMessage("The value <%s> doesn't match the regex <%s>", new Object[]{value, regex});
    }

    public CollectionAssert hasFlattenedSizeGreaterThanOrEqualTo(int size) {
        this.isNotNull();
        int flattenedSize = this.flattenedSize(0, this.actual);
        if (flattenedSize < size) {
            this.failWithMessage("The flattened size <%s> is not greater or equal to <%s>", new Object[]{flattenedSize, size});
        }
        return this;
    }

    public CollectionAssert hasFlattenedSizeLessThanOrEqualTo(int size) {
        this.isNotNull();
        int flattenedSize = this.flattenedSize(0, this.actual);
        if (flattenedSize > size) {
            this.failWithMessage("The flattened size <%s> is not less or equal to <%s>", new Object[]{flattenedSize, size});
        }
        return this;
    }

    public CollectionAssert hasFlattenedSizeBetween(int lowerBound, int higherBound) {
        this.isNotNull();
        int flattenedSize = this.flattenedSize(0, this.actual);
        if (flattenedSize < lowerBound || flattenedSize > higherBound) {
            this.failWithMessage("The flattened size <%s> is not between <%s> and <%s>", new Object[]{flattenedSize, lowerBound, higherBound});
        }
        return this;
    }

    public CollectionAssert hasSizeGreaterThanOrEqualTo(int size) {
        this.isNotNull();
        int actualSize = this.size((Iterable)this.actual);
        if (actualSize < size) {
            this.failWithMessage("The size <%s> is not greater or equal to <%s>", new Object[]{actualSize, size});
        }
        return this;
    }

    public CollectionAssert hasSizeLessThanOrEqualTo(int size) {
        this.isNotNull();
        int actualSize = this.size((Iterable)this.actual);
        if (actualSize > size) {
            this.failWithMessage("The size <%s> is not less or equal to <%s>", new Object[]{actualSize, size});
        }
        return this;
    }

    public CollectionAssert hasSizeBetween(int lowerBound, int higherBound) {
        this.isNotNull();
        int size = this.size((Iterable)this.actual);
        if (size < lowerBound || size > higherBound) {
            this.failWithMessage("The size <%s> is not between <%s> and <%s>", new Object[]{size, lowerBound, higherBound});
        }
        return this;
    }

    private int flattenedSize(int counter, Object object) {
        if (object instanceof Map) {
            return counter + ((Map)object).size();
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                counter = this.flattenedSize(counter, next);
            }
            return counter;
        }
        if (object instanceof Collection) {
            return this.flattenedSize(counter, ((Collection)object).iterator());
        }
        return counter;
    }

    private int size(Iterable iterable) {
        int size = 0;
        for (Object value : iterable) {
            ++size;
        }
        return size;
    }
}

