/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;

class CompositeStubDownloader
implements StubDownloader {
    private static final Log log = LogFactory.getLog(CompositeStubDownloader.class);
    private final List<StubDownloaderBuilder> builders;
    private final StubRunnerOptions stubRunnerOptions;

    CompositeStubDownloader(List<StubDownloaderBuilder> builders, StubRunnerOptions stubRunnerOptions) {
        this.builders = builders;
        this.stubRunnerOptions = stubRunnerOptions;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered following stub downloaders " + String.valueOf(this.builders.stream().map(b -> b.getClass().getName()).collect(Collectors.toList()))));
        }
    }

    @Override
    public Map.Entry<StubConfiguration, File> downloadAndUnpackStubJar(StubConfiguration stubConfiguration) {
        Map.Entry<StubConfiguration, File> entry = this.entry(stubConfiguration);
        if (entry != null) {
            return entry;
        }
        log.warn((Object)"No matching stubs or contracts were found");
        if (this.stubRunnerOptions.isFailOnNoStubs()) {
            throw new IllegalArgumentException("No stubs or contracts were found for [" + stubConfiguration.toColonSeparatedDependencyNotation() + "] and the switch to fail on no stubs was set.");
        }
        return null;
    }

    private Map.Entry<StubConfiguration, File> entry(StubConfiguration stubConfiguration) {
        for (StubDownloaderBuilder builder : this.builders) {
            Map.Entry<StubConfiguration, File> entry;
            StubDownloader downloader = builder.build(this.stubRunnerOptions);
            if (downloader == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a matching stub downloader [" + downloader.getClass().getName() + "]"));
            }
            if ((entry = downloader.downloadAndUnpackStubJar(stubConfiguration)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found a matching entry [" + String.valueOf(entry) + "] by stub downloader [" + downloader.getClass().getName() + "]"));
                }
                return entry;
            }
            log.warn((Object)("Stub Downloader [" + downloader.getClass().getName() + "] failed to find an entry for [" + stubConfiguration.toColonSeparatedDependencyNotation() + "]. Will proceed to the next one"));
        }
        return null;
    }
}

