/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.springframework.cloud.contract.stubrunner.AetherFactories;
import org.springframework.cloud.contract.stubrunner.MavenSettings;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.TemporaryFileStorage;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.stubrunner.util.ZipCategory;
import org.springframework.util.StringUtils;

public class AetherStubDownloader
implements StubDownloader {
    private static final Log log = LogFactory.getLog(AetherStubDownloader.class);
    private static final String TEMP_DIR_PREFIX = "contracts";
    private static final String ARTIFACT_EXTENSION = "jar";
    private static final String LATEST_ARTIFACT_VERSION = "(,]";
    private static final String LATEST_VERSION_IN_IVY = "+";
    private static final Class CLAZZ = TemporaryFileStorage.class;
    private static RepositorySystem repositorySystemFromMaven;
    private final List<RemoteRepository> remoteRepos;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;
    private final boolean workOffline;
    private final boolean deleteStubsAfterTest;
    private final Settings settings;

    public AetherStubDownloader(StubRunnerOptions stubRunnerOptions) {
        this.deleteStubsAfterTest = stubRunnerOptions.isDeleteStubsAfterTest();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will be resolving versions for the following options: [" + String.valueOf(stubRunnerOptions) + "]"));
        }
        this.settings = AetherFactories.settings();
        this.remoteRepos = this.remoteRepositories(stubRunnerOptions);
        boolean remoteReposMissing = this.remoteReposMissing();
        switch (stubRunnerOptions.stubsMode) {
            case LOCAL: {
                log.info((Object)"Remote repos not passed but the switch to work offline was set. Stubs will be used from your local Maven repository.");
                break;
            }
            case REMOTE: {
                if (!remoteReposMissing) break;
                throw new IllegalStateException("Remote repositories for stubs are not specified and work offline flag wasn't passed");
            }
            case CLASSPATH: {
                throw new UnsupportedOperationException("You can't use Aether downloader when you use classpath to find stubs");
            }
        }
        this.repositorySystem = AetherFactories.repositorySystemOr(repositorySystemFromMaven);
        this.workOffline = stubRunnerOptions.stubsMode == StubRunnerProperties.StubsMode.LOCAL;
        this.session = AetherFactories.newSession(this.repositorySystem, this.workOffline);
        this.registerShutdownHook();
    }

    public AetherStubDownloader(RepositorySystem repositorySystem, List<RemoteRepository> remoteRepositories, RepositorySystemSession session, Settings settings) {
        this.deleteStubsAfterTest = true;
        this.remoteRepos = remoteRepositories;
        this.settings = settings;
        this.repositorySystem = repositorySystem;
        this.session = session;
        if (this.remoteReposMissing()) {
            log.error((Object)"Remote repositories for stubs are not specified and work offline flag wasn't passed");
        }
        this.workOffline = false;
        this.registerShutdownHook();
    }

    private static File unpackStubJarToATemporaryFolder(URI stubJarUri) {
        File tmpDirWhereStubsWillBeUnzipped = TemporaryFileStorage.createTempDir(TEMP_DIR_PREFIX);
        log.info((Object)("Unpacking stub from JAR [URI: " + String.valueOf(stubJarUri) + "]"));
        ZipCategory.unzipTo(new File(stubJarUri), tmpDirWhereStubsWillBeUnzipped);
        TemporaryFileStorage.add(tmpDirWhereStubsWillBeUnzipped);
        return tmpDirWhereStubsWillBeUnzipped;
    }

    private boolean remoteReposMissing() {
        return this.remoteRepos == null || this.remoteRepos.isEmpty();
    }

    private List<RemoteRepository> remoteRepositories(StubRunnerOptions stubRunnerOptions) {
        if (stubRunnerOptions.stubRepositoryRoot == null) {
            return new ArrayList<RemoteRepository>();
        }
        String[] repos = stubRunnerOptions.getStubRepositoryRootAsString().split(",");
        ArrayList<RemoteRepository> remoteRepos = new ArrayList<RemoteRepository>();
        for (int i = 0; i < repos.length; ++i) {
            if (!StringUtils.hasText((String)repos[i])) continue;
            RemoteRepository.Builder builder = new RemoteRepository.Builder("remote" + i, "default", repos[i]).setAuthentication(this.resolveAuthentication(stubRunnerOptions));
            if (stubRunnerOptions.getProxyOptions() != null) {
                StubRunnerOptions.StubRunnerProxyOptions p = stubRunnerOptions.getProxyOptions();
                builder.setProxy(new Proxy(null, p.getProxyHost(), p.getProxyPort()));
            }
            remoteRepos.add(builder.build());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using the following remote repos " + String.valueOf(remoteRepos)));
        }
        return remoteRepos;
    }

    private Authentication resolveAuthentication(StubRunnerOptions stubRunnerOptions) {
        Server stubServer;
        if (StringUtils.hasText((String)stubRunnerOptions.serverId) && (stubServer = this.settings.getServer(stubRunnerOptions.serverId)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Custom server id [" + stubServer.getId() + "] passed will resolve credentials"));
            }
            DefaultSettingsDecryptionRequest settingsDecryptionRequest = new DefaultSettingsDecryptionRequest(stubServer);
            String stubServerPassword = new MavenSettings().createSettingsDecrypter().decrypt((SettingsDecryptionRequest)settingsDecryptionRequest).getServer().getPassword();
            return this.buildAuthentication(stubServerPassword, stubServer.getUsername());
        }
        return this.buildAuthentication(stubRunnerOptions.password, stubRunnerOptions.username);
    }

    Authentication buildAuthentication(String stubServerPassword, String username) {
        return new AuthenticationBuilder().addUsername(username).addPassword(stubServerPassword).build();
    }

    private File unpackedJar(String resolvedVersion, String stubsGroup, String stubsModule, String classifier) {
        try {
            log.info((Object)("Resolved version is [" + resolvedVersion + "]"));
            if (!StringUtils.hasText((String)resolvedVersion)) {
                log.warn((Object)("Stub for group [" + stubsGroup + "] module [" + stubsModule + "] and classifier [" + classifier + "] not found in " + String.valueOf(this.remoteRepos)));
                return null;
            }
            DefaultArtifact artifact = new DefaultArtifact(stubsGroup, stubsModule, classifier, ARTIFACT_EXTENSION, resolvedVersion);
            ArtifactRequest request = new ArtifactRequest((Artifact)artifact, this.remoteRepos, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolving artifact [" + String.valueOf(artifact) + "] using remote repositories " + String.valueOf(this.remoteRepos)));
            }
            ArtifactResult result = this.repositorySystem.resolveArtifact(this.session, request);
            log.info((Object)("Resolved artifact [" + String.valueOf(artifact) + "] to " + String.valueOf(result.getArtifact().getFile())));
            File temporaryFile = AetherStubDownloader.unpackStubJarToATemporaryFolder(result.getArtifact().getFile().toURI());
            log.info((Object)("Unpacked file to [" + String.valueOf(temporaryFile) + "]"));
            return temporaryFile;
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception occurred while trying to download a stub for group [" + stubsGroup + "] module [" + stubsModule + "] and classifier [" + classifier + "] in " + String.valueOf(this.remoteRepos), e);
        }
    }

    private String getVersion(String stubsGroup, String stubsModule, String version, String classifier) {
        if (!StringUtils.hasText((String)version) || LATEST_VERSION_IN_IVY.equals(version)) {
            log.info((Object)("Desired version is [" + version + "] - will try to resolve the latest version"));
            return this.resolveHighestArtifactVersion(stubsGroup, stubsModule, classifier, LATEST_ARTIFACT_VERSION);
        }
        return this.resolveHighestArtifactVersion(stubsGroup, stubsModule, classifier, version);
    }

    @Override
    public Map.Entry<StubConfiguration, File> downloadAndUnpackStubJar(StubConfiguration stubConfiguration) {
        try {
            File unpackedJar;
            String version = this.getVersion(stubConfiguration.groupId, stubConfiguration.artifactId, stubConfiguration.version, stubConfiguration.classifier);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will download the stub for version [" + version + "]"));
            }
            if ((unpackedJar = this.unpackedJar(version, stubConfiguration.groupId, stubConfiguration.artifactId, stubConfiguration.classifier)) == null) {
                return null;
            }
            return new AbstractMap.SimpleEntry<StubConfiguration, File>(new StubConfiguration(stubConfiguration.groupId, stubConfiguration.artifactId, version, stubConfiguration.classifier), unpackedJar);
        }
        catch (Exception ex) {
            log.warn((Object)"Exception occurred while trying to fetch the stubs", (Throwable)ex);
            return null;
        }
    }

    private String resolveHighestArtifactVersion(String stubsGroup, String stubsModule, String classifier, String version) {
        VersionRangeResult rangeResult;
        DefaultArtifact artifact = new DefaultArtifact(stubsGroup, stubsModule, classifier, ARTIFACT_EXTENSION, version);
        VersionRangeRequest versionRangeRequest = new VersionRangeRequest((Artifact)artifact, this.remoteRepos, null);
        try {
            rangeResult = this.repositorySystem.resolveVersionRange(this.session, versionRangeRequest);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolved version range is [" + String.valueOf(rangeResult) + "]"));
            }
        }
        catch (VersionRangeResolutionException e) {
            throw new IllegalStateException("Cannot resolve version range", e);
        }
        if (rangeResult.getHighestVersion() == null) {
            throw new IllegalArgumentException("For groupId [" + stubsGroup + "] artifactId [" + stubsModule + "] and classifier [" + classifier + "] the version was not resolved! The following exceptions took place " + String.valueOf(rangeResult.getExceptions()));
        }
        return rangeResult.getHighestVersion() == null ? null : rangeResult.getHighestVersion().toString();
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> TemporaryFileStorage.cleanup(this.deleteStubsAfterTest)));
    }

    public static void setRepositorySystemFromMaven(RepositorySystem fromMaven) {
        repositorySystemFromMaven = fromMaven;
    }
}

