/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.util.StringUtils;

public final class StubsParser {
    private StubsParser() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static List<StubConfiguration> fromString(Collection<String> collection, String defaultClassifier) {
        ArrayList<StubConfiguration> stubs = new ArrayList<StubConfiguration>();
        for (String config : collection) {
            if (!StringUtils.hasText((String)config)) continue;
            stubs.add(StubSpecification.parse((String)config, (String)defaultClassifier).stub);
        }
        return stubs;
    }

    public static Map<StubConfiguration, Integer> fromStringWithPort(String notation) {
        StubSpecification stub = StubSpecification.parse(notation, "stubs");
        if (!stub.hasPort()) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(stub.stub, stub.port);
    }

    public static String ivyFromStringWithPort(String notation) {
        StubSpecification stub = StubSpecification.parse(notation, "stubs");
        if (!stub.hasPort()) {
            return "";
        }
        return stub.stub.toColonSeparatedDependencyNotation();
    }

    public static boolean hasPort(String id) {
        String[] splitEntry = id.split(":");
        try {
            Integer.valueOf(splitEntry[splitEntry.length - 1]);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static class StubSpecification {
        private final StubConfiguration stub;
        private final Integer port;

        StubSpecification(StubConfiguration stub, Integer port) {
            this.stub = stub;
            this.port = port;
        }

        private static StubSpecification parse(String id, String defaultClassifier) {
            String[] splitEntry = id.split(":");
            Integer port = null;
            try {
                port = Integer.valueOf(splitEntry[splitEntry.length - 1]);
                id = id.substring(0, id.lastIndexOf(":"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new StubSpecification(new StubConfiguration(id, defaultClassifier), port);
        }

        public boolean hasPort() {
            return this.port != null;
        }
    }
}

