/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.RepoRoot;
import org.springframework.cloud.contract.stubrunner.RepoRoots;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.TemporaryFileStorage;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

class ResourceResolvingStubDownloader
implements StubDownloader {
    private static final Log log = LogFactory.getLog(ResourceResolvingStubDownloader.class);
    private final StubRunnerOptions stubRunnerOptions;
    private final BiFunction<StubRunnerOptions, StubConfiguration, RepoRoots> repoRootFunction;
    private final Function<StubConfiguration, Pattern> gavPattern;
    private final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver((ResourceLoader)new DefaultResourceLoader());

    ResourceResolvingStubDownloader(StubRunnerOptions stubRunnerOptions, BiFunction<StubRunnerOptions, StubConfiguration, RepoRoots> repoRootFunction, Function<StubConfiguration, Pattern> gavPattern) {
        this.stubRunnerOptions = stubRunnerOptions;
        this.repoRootFunction = repoRootFunction;
        this.gavPattern = gavPattern;
    }

    @Override
    public Map.Entry<StubConfiguration, File> downloadAndUnpackStubJar(StubConfiguration config) {
        this.registerShutdownHook();
        List repoRoots = this.repoRootFunction.apply(this.stubRunnerOptions, config);
        List<String> paths = this.toPaths(repoRoots);
        List<Resource> resources = this.resolveResources(paths);
        if (log.isDebugEnabled()) {
            log.debug((Object)("For paths " + String.valueOf(paths) + " found following resources " + String.valueOf(resources)));
        }
        if (resources.isEmpty() && this.stubRunnerOptions.isFailOnNoStubs()) {
            throw new IllegalStateException("No stubs were found on classpath for [" + config.getGroupId() + ":" + config.getArtifactId() + "]");
        }
        File tmp = TemporaryFileStorage.createTempDir("classpath-stubs");
        if (this.stubRunnerOptions.isDeleteStubsAfterTest()) {
            tmp.deleteOnExit();
        }
        boolean atLeastOneFound = false;
        for (Resource resource : resources) {
            try {
                String relativePath = this.relativePathPicker(resource, this.gavPattern.apply(config));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Relative path for resource is [" + relativePath + "]"));
                }
                if (relativePath == null) {
                    log.warn((Object)("Unable to match the URI [" + String.valueOf(resource.getURI()) + "]"));
                    continue;
                }
                atLeastOneFound = true;
                this.copyTheFoundFiles(tmp, resource, relativePath);
            }
            catch (IOException e) {
                log.error((Object)"Exception occurred while trying to create dirs", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        if (!atLeastOneFound) {
            log.warn((Object)"Didn't find any matching stubs");
            return null;
        }
        log.info((Object)("Unpacked files for [" + config.getGroupId() + ":" + config.getArtifactId() + ":" + config.getVersion() + "] to folder [" + String.valueOf(tmp) + "]"));
        return new AbstractMap.SimpleEntry<StubConfiguration, File>(new StubConfiguration(config.getGroupId(), config.getArtifactId(), config.getVersion(), config.getClassifier()), tmp);
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> TemporaryFileStorage.cleanup(this.stubRunnerOptions.isDeleteStubsAfterTest())));
    }

    private void copyTheFoundFiles(File tmp, Resource resource, String relativePath) throws IOException {
        Path directory;
        File newFile;
        String relativePathWithoutFile;
        int lastIndexOf = relativePath.lastIndexOf("/");
        String string = relativePathWithoutFile = lastIndexOf > -1 ? relativePath.substring(0, lastIndexOf) : relativePath;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Relative path without file name is [" + relativePathWithoutFile + "]"));
        }
        if (!(newFile = new File((directory = Files.createDirectories(new File(tmp, relativePathWithoutFile).toPath(), new FileAttribute[0])).toFile(), resource.getFilename())).exists() && !this.isDirectory(resource)) {
            try (InputStream stream = resource.getInputStream();){
                Files.copy(stream, newFile.toPath(), new CopyOption[0]);
                TemporaryFileStorage.add(newFile);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stored file [" + String.valueOf(newFile) + "]"));
        }
    }

    boolean isDirectory(Resource resource) {
        try {
            return resource.getFile().isDirectory();
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Exception occurred while trying to convert path to file for resource [" + String.valueOf(resource) + "]"), (Throwable)e);
            }
            return false;
        }
    }

    String relativePathPicker(Resource resource, Pattern groupAndArtifactPattern) throws IOException {
        Matcher groupAndArtifactMatcher = this.matcher(resource, groupAndArtifactPattern);
        if (groupAndArtifactMatcher.matches() && groupAndArtifactMatcher.groupCount() > 2) {
            MatchResult groupAndArtifactResult = groupAndArtifactMatcher.toMatchResult();
            return groupAndArtifactResult.group(2) + groupAndArtifactResult.group(3);
        }
        if (groupAndArtifactMatcher.matches()) {
            return groupAndArtifactMatcher.group(1);
        }
        return null;
    }

    private Matcher matcher(Resource resource, Pattern groupAndArtifactPattern) throws IOException {
        try {
            String path = resource.getURI().getPath();
            return groupAndArtifactPattern.matcher(path);
        }
        catch (Exception ex) {
            String path = resource.getURI().toString();
            return groupAndArtifactPattern.matcher(path);
        }
    }

    private List<String> toPaths(List<RepoRoot> repoRoots) {
        ArrayList<String> list = new ArrayList<String>();
        for (RepoRoot repoRoot : repoRoots) {
            list.add(repoRoot.fullPath);
        }
        return list;
    }

    List<Resource> resolveResources(List<String> paths) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String path : paths) {
            try {
                List<Resource> list = Arrays.asList(this.resolver.getResources(path));
                resources.addAll(list);
            }
            catch (IOException e) {
                log.error((Object)("Exception occurred while trying to fetch resources from [" + path + "]"));
                throw new IllegalStateException(e);
            }
        }
        return resources;
    }
}

