/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud.loadbalancer;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.cloud.contract.stubrunner.spring.cloud.loadbalancer.StubbedServiceInstance;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import reactor.core.publisher.Mono;

class ContractReactorServiceInstanceLoadBalancer
implements ReactorServiceInstanceLoadBalancer,
LoadBalancerLifecycle {
    private final BeanFactory beanFactory;
    private final String serviceId;
    private StubFinder stubFinder;
    private StubMapperProperties stubMapperProperties;

    ContractReactorServiceInstanceLoadBalancer(BeanFactory beanFactory, String serviceId) {
        this.beanFactory = beanFactory;
        this.serviceId = serviceId;
    }

    public void onStart(Request request) {
    }

    public void onStartRequest(Request request, Response lbResponse) {
    }

    public void onComplete(CompletionContext completionContext) {
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        return Mono.just((Object)new DefaultResponse((ServiceInstance)new StubbedServiceInstance(this.stubFinder(), this.stubMapperProperties(), this.serviceId)));
    }

    private StubFinder stubFinder() {
        if (this.stubFinder == null) {
            this.stubFinder = (StubFinder)this.beanFactory.getBean(StubFinder.class);
        }
        return this.stubFinder;
    }

    private StubMapperProperties stubMapperProperties() {
        if (this.stubMapperProperties == null) {
            this.stubMapperProperties = (StubMapperProperties)this.beanFactory.getBean(StubMapperProperties.class);
        }
        return this.stubMapperProperties;
    }
}

