/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.lang.reflect.Field;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.springframework.util.StringUtils;
import shaded.org.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import shaded.org.apache.maven.settings.crypto.SettingsDecrypter;

public class MavenSettings {
    private static final String MAVEN_USER_CONFIG_DIRECTORY = "maven.user.config.dir";
    private final String homeDir;

    public MavenSettings() {
        this(MavenSettings.userSettings());
    }

    private static String fromSystemPropOrEnv(String prop) {
        String resolvedProp = System.getProperty(prop);
        if (StringUtils.hasText((String)resolvedProp)) {
            return resolvedProp;
        }
        return System.getenv(prop);
    }

    private static String userSettings() {
        String user = MavenSettings.fromSystemPropOrEnv(MAVEN_USER_CONFIG_DIRECTORY);
        if (user == null) {
            return System.getProperty("user.home");
        }
        return user;
    }

    public MavenSettings(String homeDir) {
        this.homeDir = homeDir;
    }

    public SettingsDecrypter createSettingsDecrypter() {
        DefaultSettingsDecrypter settingsDecrypter = new DefaultSettingsDecrypter();
        this.setField(DefaultSettingsDecrypter.class, "securityDispatcher", settingsDecrypter, (Object)new SpringCloudContractSecDispatcher());
        return settingsDecrypter;
    }

    private void setField(Class<?> sourceClass, String fieldName, Object target, Object value) {
        try {
            Field field = sourceClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to set field '" + fieldName + "' on '" + target + "'", ex);
        }
    }

    private class SpringCloudContractSecDispatcher
    extends DefaultSecDispatcher {
        private static final String SECURITY_XML = "settings-security.xml";

        SpringCloudContractSecDispatcher() {
            File file = new File(MavenSettings.this.homeDir, SECURITY_XML);
            this._configurationFile = file.getAbsolutePath();
            try {
                this._cipher = new DefaultPlexusCipher();
            }
            catch (PlexusCipherException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

