/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.kafka;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.messaging.kafka.StubRunnerKafkaRouter;
import org.springframework.cloud.contract.verifier.messaging.kafka.ContractVerifierKafkaConfiguration;
import org.springframework.cloud.contract.verifier.messaging.kafka.KafkaStubMessagesInitializer;
import org.springframework.cloud.contract.verifier.util.MapConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.GenericMessageListener;
import org.springframework.kafka.listener.KafkaMessageListenerContainer;
import org.springframework.kafka.test.EmbeddedKafkaBroker;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={KafkaTemplate.class, EmbeddedKafkaBroker.class})
@ConditionalOnProperty(name={"stubrunner.kafka.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={EmbeddedKafkaBroker.class})
@AutoConfigureBefore(value={ContractVerifierKafkaConfiguration.class})
public class StubRunnerKafkaConfiguration {
    private static final Log log = LogFactory.getLog(StubRunnerKafkaConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"stubrunner.kafka.initializer.enabled"}, havingValue="true", matchIfMissing=true)
    KafkaStubMessagesInitializer stubRunnerKafkaStubMessagesInitializer() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registering a noop kafka messages initializer");
        }
        return (broker, kafkaProperties) -> new HashMap();
    }

    @Bean
    @ConditionalOnMissingBean(name={"stubFlowRegistrar"})
    public FlowRegistrar stubFlowRegistrar(ConfigurableListableBeanFactory beanFactory, BatchStubRunner batchStubRunner) {
        Map<StubConfiguration, Collection<Contract>> contracts = batchStubRunner.getContracts();
        for (Map.Entry<StubConfiguration, Collection<Contract>> entry : contracts.entrySet()) {
            StubConfiguration key = entry.getKey();
            Collection<Contract> value = entry.getValue();
            String name = key.getGroupId() + "_" + key.getArtifactId();
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            for (Contract dsl : value) {
                if (dsl == null || dsl.getInput() == null || dsl.getInput().getMessageFrom() == null || !StringUtils.hasText((String)((String)dsl.getInput().getMessageFrom().getClientValue()))) continue;
                String from = (String)dsl.getInput().getMessageFrom().getClientValue();
                map.add((Object)from, (Object)dsl);
            }
            for (Map.Entry entries : map.entrySet()) {
                List matchingContracts = (List)entries.getValue();
                String flowName = name + "_" + (String)entries.getKey() + "_" + Math.abs(matchingContracts.hashCode());
                StubRunnerKafkaRouter router = new StubRunnerKafkaRouter(matchingContracts, (BeanFactory)beanFactory);
                StubRunnerKafkaRouter listener = (StubRunnerKafkaRouter)beanFactory.initializeBean((Object)router, flowName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized kafka router with name [" + flowName + "]"));
                }
                beanFactory.registerSingleton(flowName, (Object)listener);
                this.registerContainers(beanFactory, matchingContracts, flowName, listener);
            }
        }
        return new FlowRegistrar();
    }

    private void registerContainers(ConfigurableListableBeanFactory beanFactory, List<Contract> matchingContracts, String flowName, StubRunnerKafkaRouter listener) {
        ConsumerFactory consumerFactory = (ConsumerFactory)beanFactory.getBean(ConsumerFactory.class);
        for (Contract matchingContract : matchingContracts) {
            if (matchingContract.getInput() == null) continue;
            String destination = MapConverter.getStubSideValuesForNonBody((Object)matchingContract.getInput().getMessageFrom()).toString();
            ContainerProperties containerProperties = new ContainerProperties(new String[]{destination});
            KafkaMessageListenerContainer container = this.listenerContainer(consumerFactory, containerProperties, (GenericMessageListener)listener);
            String containerName = flowName + ".container";
            Object initializedContainer = beanFactory.initializeBean((Object)container, containerName);
            beanFactory.registerSingleton(containerName, initializedContainer);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Initialized kafka message container with name [" + containerName + "] listening to destination [" + destination + "]"));
        }
    }

    private KafkaMessageListenerContainer listenerContainer(ConsumerFactory consumerFactory, ContainerProperties containerProperties, GenericMessageListener listener) {
        KafkaMessageListenerContainer container = new KafkaMessageListenerContainer(consumerFactory, containerProperties);
        container.setupMessageListener((Object)listener);
        return container;
    }

    static class FlowRegistrar {
        FlowRegistrar() {
        }
    }
}

