/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud.zookeeper;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceInstance;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.stubrunner.StubRunning;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerConfiguration;
import org.springframework.cloud.contract.stubrunner.spring.cloud.ConditionalOnStubbedDiscoveryDisabled;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubsRegistrar;
import org.springframework.cloud.contract.stubrunner.spring.cloud.zookeeper.ZookeeperStubsRegistrar;
import org.springframework.cloud.zookeeper.discovery.ConditionalOnZookeeperDiscoveryEnabled;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.support.CuratorServiceDiscoveryAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={StubRunnerConfiguration.class, CuratorServiceDiscoveryAutoConfiguration.class})
@ConditionalOnClass(value={ServiceInstance.class})
@ConditionalOnStubbedDiscoveryDisabled
@ConditionalOnZookeeperDiscoveryEnabled
@ConditionalOnProperty(value={"stubrunner.cloud.zookeeper.enabled"}, matchIfMissing=true)
public class StubRunnerSpringCloudZookeeperAutoConfiguration {
    @Bean(initMethod="registerStubs")
    public StubsRegistrar stubsRegistrar(StubRunning stubRunning, CuratorFramework curatorFramework, StubMapperProperties stubMapperProperties, ZookeeperDiscoveryProperties zookeeperDiscoveryProperties) {
        return new ZookeeperStubsRegistrar(stubRunning, curatorFramework, stubMapperProperties, zookeeperDiscoveryProperties);
    }
}

