/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring;

import java.lang.reflect.Field;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerPort;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;

class StubRunnerPortFieldCallback
implements ReflectionUtils.FieldCallback {
    private final Environment environment;
    private final Object bean;

    StubRunnerPortFieldCallback(Environment environment, Object bean) {
        this.environment = environment;
        this.bean = bean;
    }

    public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
        if (!field.isAnnotationPresent(StubRunnerPort.class)) {
            return;
        }
        ReflectionUtils.makeAccessible((Field)field);
        String stub = field.getDeclaredAnnotation(StubRunnerPort.class).value();
        Integer port = (Integer)this.environment.getProperty("stubrunner.runningstubs." + stub.replace(":", ".") + ".port", Integer.class);
        if (port != null) {
            field.set(this.bean, port);
        }
    }
}

