/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.util;

public class StringUtils {
    private static final String EMPTY = "";
    private static final int INDEX_NOT_FOUND = -1;

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty();
    }

    public static boolean hasText(String string) {
        if (!StringUtils.isNotEmpty(string)) {
            return false;
        }
        int strLen = string.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String substringBeforeLast(String str, String separator) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfterLast(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (StringUtils.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }
}

