/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.amqp;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.adapter.MessageListenerAdapter;
import org.springframework.amqp.support.converter.ContentTypeDelegatingMessageConverter;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.contract.stubrunner.messaging.amqp.MessageSubscriber;
import org.springframework.cloud.contract.stubrunner.messaging.amqp.MessageSubscriberRabbitListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@SpringBootApplication
public class AmqpMessagingApplication {
    public static void main(String[] args) {
        SpringApplication.run(AmqpMessagingApplication.class, (String[])args);
    }

    @Bean
    public MessageConverter messageConverter(ObjectMapper objectMapper) {
        Jackson2JsonMessageConverter jsonMessageConverter = new Jackson2JsonMessageConverter(objectMapper);
        jsonMessageConverter.setCreateMessageIds(true);
        ContentTypeDelegatingMessageConverter messageConverter = new ContentTypeDelegatingMessageConverter((MessageConverter)jsonMessageConverter);
        messageConverter.addDelegate("application/json", (MessageConverter)jsonMessageConverter);
        return messageConverter;
    }

    @Bean
    public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory, MessageConverter messageConverter) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setMessageConverter(messageConverter);
        return rabbitTemplate;
    }

    @Configuration(proxyBeanMethods=false)
    @EnableRabbit
    @Profile(value={"listener"})
    static class RabbitListenerConfig {
        RabbitListenerConfig() {
        }

        @Bean
        public MessageSubscriberRabbitListener messageSubscriberRabbitLister() {
            return new MessageSubscriberRabbitListener();
        }

        @Bean
        public SimpleRabbitListenerContainerFactory rabbitListenerContainerFactory(ConnectionFactory connectionFactory, MessageConverter messageConverter) {
            SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
            factory.setConnectionFactory(connectionFactory);
            factory.setConcurrentConsumers(Integer.valueOf(3));
            factory.setMaxConcurrentConsumers(Integer.valueOf(10));
            factory.setMessageConverter(messageConverter);
            return factory;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Profile(value={"!listener"})
    static class MessageListenerAdapterConfig {
        MessageListenerAdapterConfig() {
        }

        @Bean
        public MessageListenerAdapter messageListenerAdapter(MessageSubscriber messageSubscriber, MessageConverter messageConverter) {
            return new MessageListenerAdapter((Object)messageSubscriber, messageConverter);
        }

        @Bean
        public Binding binding() {
            return BindingBuilder.bind((Queue)new Queue("test.queue")).to(new DirectExchange("contract-test.exchange")).with("#");
        }

        @Bean
        public SimpleMessageListenerContainer simpleMessageListenerContainer(ConnectionFactory connectionFactory, MessageListenerAdapter listenerAdapter) {
            SimpleMessageListenerContainer container = new SimpleMessageListenerContainer();
            container.setConnectionFactory(connectionFactory);
            container.setQueueNames(new String[]{"test.queue"});
            container.setMessageListener((MessageListener)listenerAdapter);
            return container;
        }

        @Bean
        public MessageSubscriber messageSubscriber() {
            return new MessageSubscriber();
        }
    }
}

