/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.ScriptEngineManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0016J$\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0002J)\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00150\u0017\u00a2\u0006\u0002\b\u0019H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/springframework/cloud/contract/spec/internal/KotlinContractConverter;", "Lorg/springframework/cloud/contract/spec/ContractConverter;", "", "Lorg/springframework/cloud/contract/spec/Contract;", "()V", "ext", "", "convertFrom", "", "file", "Ljava/io/File;", "convertTo", "contract", "defaultContractName", "contracts", "counter", "", "isAccepted", "", "withName", "withUpdatedClassloader", "", "block", "Lkotlin/Function1;", "Ljava/lang/ClassLoader;", "Lkotlin/ExtensionFunctionType;", "spring-cloud-contract-spec-kotlin"})
public final class KotlinContractConverter
implements ContractConverter<List<? extends Contract>> {
    @NotNull
    private final String ext;

    public KotlinContractConverter() {
        this.ext = "kts";
        System.setProperty("idea.use.native.fs.for.win", "false");
    }

    public boolean isAccepted(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)this.ext, (Object)FilesKt.getExtension((File)file));
    }

    @NotNull
    public Collection<Contract> convertFrom(@NotNull File file) {
        Object eval2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = eval2 = this.withUpdatedClassloader(file, (Function1<? super ClassLoader, ? extends Object>)((Function1)new Function1<ClassLoader, Object>(file, this){
            final /* synthetic */ File $file;
            final /* synthetic */ KotlinContractConverter this$0;
            {
                this.$file = $file;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final Object invoke(@NotNull ClassLoader $this$withUpdatedClassloader) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)$this$withUpdatedClassloader, (String)"$this$withUpdatedClassloader");
                Object object2 = this.$file;
                Object object3 = Charsets.UTF_8;
                boolean bl = false;
                Object object4 = object2;
                boolean bl2 = false;
                object4 = new FileInputStream((File)object4);
                bl2 = false;
                object2 = new InputStreamReader((InputStream)object4, (Charset)object3);
                object3 = this.this$0;
                bl = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    InputStreamReader it = (InputStreamReader)object2;
                    boolean bl4 = false;
                    object = new ScriptEngineManager().getEngineByExtension(KotlinContractConverter.access$getExt$p((KotlinContractConverter)object3)).eval(it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
                Object object5 = object;
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"file.reader().use {\n                // Get a new engine every time we need to process a file.\n                // Reusing the script engine could leak context and will fail subsequent evals\n                ScriptEngineManager().getEngineByExtension(ext).eval(it)\n            }");
                return object5;
            }
        }));
        List contracts = object instanceof Contract ? CollectionsKt.listOf((Object)eval2) : (object instanceof Iterable ? CollectionsKt.filterIsInstance((Iterable)((Iterable)eval2), Contract.class) : (object instanceof Object[] ? ArraysKt.filterIsInstance((Object[])((Object[])eval2), Contract.class) : CollectionsKt.emptyList()));
        return this.withName(file, contracts);
    }

    private final Collection<Contract> withName(File file, Collection<? extends Contract> contracts) {
        AtomicInteger counter = new AtomicInteger(0);
        Iterable $this$onEach$iv = contracts;
        boolean $i$f$onEach = false;
        Iterable iterable = $this$onEach$iv;
        boolean bl = false;
        boolean bl2 = false;
        Iterable $this$apply$iv = iterable;
        boolean bl3 = false;
        for (Object element$iv : $this$apply$iv) {
            Contract contract = (Contract)element$iv;
            boolean bl4 = false;
            if (ObjectUtils.isEmpty((Object)contract.getName())) {
                contract.setName(this.defaultContractName(file, contracts, counter.get()));
            }
            counter.incrementAndGet();
        }
        return (Collection)iterable;
    }

    private final String defaultContractName(File file, Collection<?> contracts, int counter) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        int lastIndexOfDot = StringsKt.lastIndexOf$default((CharSequence)string, (String)".", (int)0, (boolean)false, (int)6, null);
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
        int n = 0;
        boolean bl = false;
        String string3 = string2.substring(n, lastIndexOfDot);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String tillExtension = string3;
        return Intrinsics.stringPlus((String)tillExtension, (Object)(counter > 0 || contracts.size() > 1 ? Intrinsics.stringPlus((String)"_", (Object)counter) : ""));
    }

    @NotNull
    public List<Contract> convertTo(@NotNull Collection<? extends Contract> contract) {
        Intrinsics.checkNotNullParameter(contract, (String)"contract");
        return CollectionsKt.toList((Iterable)contract);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object withUpdatedClassloader(File file, Function1<? super ClassLoader, ? extends Object> block) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object object = new URL[]{file.getParentFile().toURI().toURL()};
            URLClassLoader tempClassLoader = URLClassLoader.newInstance(object, currentClassLoader);
            Thread.currentThread().setContextClassLoader(tempClassLoader);
            Intrinsics.checkNotNullExpressionValue((Object)tempClassLoader, (String)"tempClassLoader");
            object = block.invoke((Object)tempClassLoader);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public static final /* synthetic */ String access$getExt$p(KotlinContractConverter $this) {
        return $this.ext;
    }
}

