/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.Common;
import org.springframework.cloud.contract.spec.internal.Cookies;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.FromRequest;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.OptionalProperty;
import org.springframework.cloud.contract.spec.internal.PatternValueDslProperty;
import org.springframework.cloud.contract.spec.internal.RegexCreatingProperty;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.spec.internal.ResponseBodyMatchers;
import org.springframework.cloud.contract.spec.internal.ServerDslProperty;
import org.springframework.cloud.contract.spec.util.RegexpUtils;

public class Response
extends Common
implements RegexCreatingProperty<ServerDslProperty> {
    private static final Log log = LogFactory.getLog(Response.class);
    private DslProperty status;
    private DslProperty delay;
    private Headers headers;
    private Cookies cookies;
    private Body body;
    private boolean async;
    private ResponseBodyMatchers bodyMatchers;
    private ServerPatternValueDslProperty property = new ServerPatternValueDslProperty();

    public Response() {
    }

    public Response(Response response) {
        this.status = response.getStatus();
        this.headers = response.getHeaders();
        this.cookies = response.getCookies();
        this.body = response.getBody();
    }

    public void status(int status) {
        this.status = this.toDslProperty(status);
    }

    public void status(DslProperty status) {
        this.status = this.toDslProperty(status);
    }

    public void body(Map<String, Object> body) {
        this.body = new Body(this.convertObjectsToDslProperties(body));
    }

    public void body(List body) {
        this.body = new Body(this.convertObjectsToDslProperties(body));
    }

    public void body(Object bodyAsValue) {
        if (bodyAsValue instanceof List) {
            this.body((List)bodyAsValue);
        } else {
            this.body = new Body(bodyAsValue);
        }
    }

    public void fixedDelayMilliseconds(int timeInMilliseconds) {
        this.delay = this.toDslProperty(timeInMilliseconds);
    }

    public void async() {
        this.async = true;
    }

    @Override
    public void assertThatSidesMatch(Object stubSide, Object testSide) {
        if (stubSide instanceof OptionalProperty) {
            throw new IllegalStateException("Optional can be used only in the test side of the response!");
        }
        super.assertThatSidesMatch(stubSide, testSide);
    }

    public DslProperty value(ServerDslProperty server) {
        Object dynamicValue = server.getServerValue();
        Object concreteValue = server.getClientValue();
        if (dynamicValue instanceof RegexProperty && server.isSingleValue()) {
            return ((RegexProperty)dynamicValue).concreteClientDynamicProducer();
        }
        return new DslProperty(concreteValue, dynamicValue);
    }

    public DslProperty $(ServerDslProperty server) {
        return this.value(server);
    }

    public DslProperty value(Pattern server) {
        return this.value(new RegexProperty(server));
    }

    public DslProperty value(RegexProperty server) {
        return this.value(new ServerDslProperty(server));
    }

    public DslProperty $(RegexProperty server) {
        return this.value(server);
    }

    public DslProperty $(Pattern server) {
        return this.value(new RegexProperty(server));
    }

    @Override
    public RegexProperty regexProperty(Object object) {
        return new RegexProperty(object).concreteClientDynamicProducer();
    }

    public FromRequest fromRequest() {
        return new FromRequest();
    }

    @Override
    public DslProperty value(ClientDslProperty client, ServerDslProperty server) {
        if (client.getClientValue() instanceof RegexProperty) {
            throw new IllegalStateException("You can't have a regular expression for the response on the client side");
        }
        return super.value(client, server);
    }

    @Override
    public DslProperty value(ServerDslProperty server, ClientDslProperty client) {
        if (client.getClientValue() instanceof RegexProperty) {
            throw new IllegalStateException("You can't have a regular expression for the response on the client side");
        }
        return super.value(server, client);
    }

    public ServerPatternValueDslProperty getProperty() {
        return this.property;
    }

    public void setProperty(ServerPatternValueDslProperty property) {
        this.property = property;
    }

    public DslProperty getStatus() {
        return this.status;
    }

    public void setStatus(DslProperty status) {
        this.status = status;
    }

    public DslProperty getDelay() {
        return this.delay;
    }

    public void setDelay(DslProperty delay) {
        this.delay = delay;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public void setCookies(Cookies cookies) {
        this.cookies = cookies;
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public boolean getAsync() {
        return this.async;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public ResponseBodyMatchers getBodyMatchers() {
        return this.bodyMatchers;
    }

    public void setBodyMatchers(ResponseBodyMatchers bodyMatchers) {
        this.bodyMatchers = bodyMatchers;
    }

    @Override
    public ServerDslProperty anyAlphaUnicode() {
        return (ServerDslProperty)this.property.anyAlphaUnicode();
    }

    @Override
    public ServerDslProperty anyAlphaNumeric() {
        return (ServerDslProperty)this.property.anyAlphaNumeric();
    }

    @Override
    public ServerDslProperty anyNumber() {
        return (ServerDslProperty)this.property.anyNumber();
    }

    @Override
    public ServerDslProperty anyInteger() {
        return (ServerDslProperty)this.property.anyInteger();
    }

    @Override
    public ServerDslProperty anyPositiveInt() {
        return (ServerDslProperty)this.property.anyPositiveInt();
    }

    @Override
    public ServerDslProperty anyDouble() {
        return (ServerDslProperty)this.property.anyDouble();
    }

    @Override
    public ServerDslProperty anyHex() {
        return (ServerDslProperty)this.property.anyHex();
    }

    @Override
    public ServerDslProperty aBoolean() {
        return (ServerDslProperty)this.property.aBoolean();
    }

    @Override
    public ServerDslProperty anyIpAddress() {
        return (ServerDslProperty)this.property.anyIpAddress();
    }

    @Override
    public ServerDslProperty anyHostname() {
        return (ServerDslProperty)this.property.anyHostname();
    }

    @Override
    public ServerDslProperty anyEmail() {
        return (ServerDslProperty)this.property.anyEmail();
    }

    @Override
    public ServerDslProperty anyUrl() {
        return (ServerDslProperty)this.property.anyUrl();
    }

    @Override
    public ServerDslProperty anyHttpsUrl() {
        return (ServerDslProperty)this.property.anyHttpsUrl();
    }

    @Override
    public ServerDslProperty anyUuid() {
        return (ServerDslProperty)this.property.anyUuid();
    }

    @Override
    public ServerDslProperty anyDate() {
        return (ServerDslProperty)this.property.anyDate();
    }

    @Override
    public ServerDslProperty anyDateTime() {
        return (ServerDslProperty)this.property.anyDateTime();
    }

    @Override
    public ServerDslProperty anyTime() {
        return (ServerDslProperty)this.property.anyTime();
    }

    @Override
    public ServerDslProperty anyIso8601WithOffset() {
        return (ServerDslProperty)this.property.anyIso8601WithOffset();
    }

    @Override
    public ServerDslProperty anyNonBlankString() {
        return (ServerDslProperty)this.property.anyNonBlankString();
    }

    @Override
    public ServerDslProperty anyNonEmptyString() {
        return (ServerDslProperty)this.property.anyNonEmptyString();
    }

    @Override
    public ServerDslProperty anyOf(String ... values) {
        return (ServerDslProperty)this.property.anyOf(values);
    }

    public int CONTINUE() {
        return 100;
    }

    public int SWITCHING_PROTOCOLS() {
        return 101;
    }

    public int PROCESSING() {
        return 102;
    }

    public int CHECKPOINT() {
        return 103;
    }

    public int OK() {
        return 200;
    }

    public int CREATED() {
        return 201;
    }

    public int ACCEPTED() {
        return 202;
    }

    public int NON_AUTHORITATIVE_INFORMATION() {
        return 203;
    }

    public int NO_CONTENT() {
        return 204;
    }

    public int RESET_CONTENT() {
        return 205;
    }

    public int PARTIAL_CONTENT() {
        return 206;
    }

    public int MULTI_STATUS() {
        return 207;
    }

    public int ALREADY_REPORTED() {
        return 208;
    }

    public int IM_USED() {
        return 226;
    }

    public int MULTIPLE_CHOICES() {
        return 300;
    }

    public int MOVED_PERMANENTLY() {
        return 301;
    }

    public int FOUND() {
        return 302;
    }

    public int SEE_OTHER() {
        return 303;
    }

    public int NOT_MODIFIED() {
        return 304;
    }

    public int TEMPORARY_REDIRECT() {
        return 307;
    }

    public int PERMANENT_REDIRECT() {
        return 308;
    }

    public int BAD_REQUEST() {
        return 400;
    }

    public int UNAUTHORIZED() {
        return 401;
    }

    public int PAYMENT_REQUIRED() {
        return 402;
    }

    public int FORBIDDEN() {
        return 403;
    }

    public int NOT_FOUND() {
        return 404;
    }

    public int METHOD_NOT_ALLOWED() {
        return 405;
    }

    public int NOT_ACCEPTABLE() {
        return 406;
    }

    public int PROXY_AUTHENTICATION_REQUIRED() {
        return 407;
    }

    public int REQUEST_TIMEOUT() {
        return 408;
    }

    public int CONFLICT() {
        return 409;
    }

    public int GONE() {
        return 410;
    }

    public int LENGTH_REQUIRED() {
        return 411;
    }

    public int PRECONDITION_FAILED() {
        return 412;
    }

    public int PAYLOAD_TOO_LARGE() {
        return 413;
    }

    public int URI_TOO_LONG() {
        return 414;
    }

    public int UNSUPPORTED_MEDIA_TYPE() {
        return 415;
    }

    public int REQUESTED_RANGE_NOT_SATISFIABLE() {
        return 416;
    }

    public int EXPECTATION_FAILED() {
        return 417;
    }

    public int I_AM_A_TEAPOT() {
        return 418;
    }

    public int UNPROCESSABLE_ENTITY() {
        return 422;
    }

    public int LOCKED() {
        return 423;
    }

    public int FAILED_DEPENDENCY() {
        return 424;
    }

    public int UPGRADE_REQUIRED() {
        return 426;
    }

    public int PRECONDITION_REQUIRED() {
        return 428;
    }

    public int TOO_MANY_REQUESTS() {
        return 429;
    }

    public int REQUEST_HEADER_FIELDS_TOO_LARGE() {
        return 431;
    }

    public int UNAVAILABLE_FOR_LEGAL_REASONS() {
        return 451;
    }

    public int INTERNAL_SERVER_ERROR() {
        return 500;
    }

    public int NOT_IMPLEMENTED() {
        return 501;
    }

    public int BAD_GATEWAY() {
        return 502;
    }

    public int SERVICE_UNAVAILABLE() {
        return 503;
    }

    public int GATEWAY_TIMEOUT() {
        return 504;
    }

    public int HTTP_VERSION_NOT_SUPPORTED() {
        return 505;
    }

    public int VARIANT_ALSO_NEGOTIATES() {
        return 506;
    }

    public int INSUFFICIENT_STORAGE() {
        return 507;
    }

    public int LOOP_DETECTED() {
        return 508;
    }

    public int BANDWIDTH_LIMIT_EXCEEDED() {
        return 509;
    }

    public int NOT_EXTENDED() {
        return 510;
    }

    public int NETWORK_AUTHENTICATION_REQUIRED() {
        return 511;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response response = (Response)o;
        return this.async == response.async && Objects.equals(this.status, response.status) && Objects.equals(this.delay, response.delay) && Objects.equals(this.headers, response.headers) && Objects.equals(this.cookies, response.cookies) && Objects.equals(this.body, response.body) && Objects.equals(this.bodyMatchers, response.bodyMatchers);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.delay, this.headers, this.cookies, this.body, this.async, this.bodyMatchers);
    }

    public String toString() {
        return "Response{\nstatus=" + String.valueOf(this.status) + ", \n\tdelay=" + String.valueOf(this.delay) + ", \n\theaders=" + String.valueOf(this.headers) + ", \n\tcookies=" + String.valueOf(this.cookies) + ", \n\tbody=" + String.valueOf(this.body) + ", \n\tasync=" + this.async + ", \n\tbodyMatchers=" + String.valueOf(this.bodyMatchers) + "}";
    }

    public void headers(Consumer<Headers> consumer) {
        this.headers = new ResponseHeaders();
        consumer.accept(this.headers);
    }

    public void cookies(Consumer<Cookies> consumer) {
        this.cookies = new ResponseCookies();
        consumer.accept(this.cookies);
    }

    public void bodyMatchers(Consumer<ResponseBodyMatchers> consumer) {
        this.bodyMatchers = new ResponseBodyMatchers();
        consumer.accept(this.bodyMatchers);
    }

    public void headers(@DelegatesTo(value=Headers.class) Closure consumer) {
        this.headers = new ResponseHeaders();
        consumer.setDelegate((Object)this.headers);
        consumer.call();
    }

    public void cookies(@DelegatesTo(value=Cookies.class) Closure consumer) {
        this.cookies = new ResponseCookies();
        consumer.setDelegate((Object)this.cookies);
        consumer.call();
    }

    public void bodyMatchers(@DelegatesTo(value=ResponseBodyMatchers.class) Closure consumer) {
        this.bodyMatchers = new ResponseBodyMatchers();
        consumer.setDelegate((Object)this.bodyMatchers);
        consumer.call();
    }

    private class ServerPatternValueDslProperty
    extends PatternValueDslProperty<ServerDslProperty> {
        private ServerPatternValueDslProperty() {
        }

        @Override
        protected ServerDslProperty createProperty(Pattern pattern, Object generatedValue) {
            return new ServerDslProperty(pattern, generatedValue);
        }
    }

    static class ResponseHeaders
    extends Headers {
        private final Common common = new Common();

        ResponseHeaders() {
        }

        @Override
        public DslProperty matching(String value) {
            return this.common.$(this.common.p(this.notEscaped(Pattern.compile(RegexpUtils.escapeSpecialRegexWithSingleEscape(value) + ".*"))), this.common.c(value));
        }
    }

    static class ResponseCookies
    extends Cookies {
        private final Common common = new Common();

        ResponseCookies() {
        }

        @Override
        public DslProperty matching(String value) {
            return this.common.$(this.common.p(this.common.regex(RegexpUtils.escapeSpecialRegexWithSingleEscape(value) + ".*")), this.common.c(value));
        }
    }

    private class ClientResponse
    extends Response {
        ClientResponse(Response enclosing, Response request) {
            super(request);
        }
    }

    private class ServerResponse
    extends Response {
        ServerResponse(Response enclosing, Response request) {
            super(request);
        }
    }
}

