/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.springframework.cloud.contract.spec.internal.ContractUtils;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.NotToEscapePattern;

public class Headers {
    private static final BiFunction<String, Header, Object> CLIENT_SIDE = (s, header) -> ContractUtils.convertStubSideRecursively(header);
    private static final BiFunction<String, Header, Object> SERVER_SIDE = (s, header) -> ContractUtils.convertTestSideRecursively(header);
    private Set<Header> entries = new LinkedHashSet<Header>();

    public void header(Map<String, Object> singleHeader) {
        Map.Entry<String, Object> first;
        Iterator<Map.Entry<String, Object>> iterator = singleHeader.entrySet().iterator();
        if (iterator.hasNext() && (first = iterator.next()) != null) {
            this.entries.add(Header.build(first.getKey(), first.getValue()));
        }
    }

    public void header(String headerKey, Object headerValue) {
        this.entries.add(Header.build(headerKey, headerValue));
    }

    public void executeForEachHeader(Consumer<Header> consumer) {
        this.entries.forEach(consumer);
    }

    public void headers(Set<Header> headers) {
        this.entries.addAll(headers);
    }

    public void accept(String contentType) {
        this.header(this.accept(), this.matching(contentType));
    }

    public void contentType(String contentType) {
        this.header("Content-Type", this.matching(contentType));
    }

    public void messagingContentType(String contentType) {
        this.header("contentType", this.matching(contentType));
    }

    public DslProperty matching(String value) {
        return new DslProperty<String>(value);
    }

    protected NotToEscapePattern notEscaped(Pattern pattern) {
        return new NotToEscapePattern(pattern);
    }

    public Map<String, Object> asMap(BiFunction<String, Header, Object> consumer) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.entries.forEach(header -> map.put(header.getName(), consumer.apply(header.getName(), (Header)header)));
        return map;
    }

    public Map<String, Object> asStubSideMap() {
        return this.asMap(CLIENT_SIDE);
    }

    public Map<String, Object> asTestSideMap() {
        return this.asMap(SERVER_SIDE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Headers headers = (Headers)o;
        return Objects.equals(this.entries, headers.entries);
    }

    public int hashCode() {
        return Objects.hash(this.entries);
    }

    public String toString() {
        return "Headers{\nentries=" + String.valueOf(this.entries) + "}";
    }

    public Set<Header> getEntries() {
        return this.entries;
    }

    public void setEntries(Set<Header> entries) {
        this.entries = entries;
    }

    public String messagingContentType() {
        return "contentType";
    }

    public String accept() {
        return "Accept";
    }

    public String acceptCharset() {
        return "Accept-Charset";
    }

    public String acceptEncoding() {
        return "Accept-Encoding";
    }

    public String acceptLanguage() {
        return "Accept-Language";
    }

    public String acceptRanges() {
        return "Accept-Ranges";
    }

    public String accessControlAllowCredentials() {
        return "Access-Control-Allow-Credentials";
    }

    public String accessControlAllowHeaders() {
        return "Access-Control-Allow-Headers";
    }

    public String accessControlAllowMethods() {
        return "Access-Control-Allow-Methods";
    }

    public String accessControlAllowOrigin() {
        return "Access-Control-Allow-Origin";
    }

    public String accessControlExposeHeaders() {
        return "Access-Control-Expose-Headers";
    }

    public String accessControlMaxAge() {
        return "Access-Control-Max-Age";
    }

    public String accessControlRequestHeaders() {
        return "Access-Control-Request-Headers";
    }

    public String accessControlRequestMethod() {
        return "Access-Control-Request-Method";
    }

    public String age() {
        return "Age";
    }

    public String allow() {
        return "Allow";
    }

    public String authorization() {
        return "Authorization";
    }

    public String cacheControl() {
        return "Cache-Control";
    }

    public String connection() {
        return "Connection";
    }

    public String contentEncoding() {
        return "Content-Encoding";
    }

    public String contentDisposition() {
        return "Content-Disposition";
    }

    public String contentLanguage() {
        return "Content-Language";
    }

    public String contentLength() {
        return "Content-Length";
    }

    public String contentLocation() {
        return "Content-Location";
    }

    public String contentRange() {
        return "Content-Range";
    }

    public String contentType() {
        return "Content-Type";
    }

    public String cookie() {
        return "Cookie";
    }

    public String date() {
        return "Date";
    }

    public String etag() {
        return "ETag";
    }

    public String expect() {
        return "Expect";
    }

    public String expires() {
        return "Expires";
    }

    public String from() {
        return "From";
    }

    public String host() {
        return "Host";
    }

    public String ifMatch() {
        return "If-Match";
    }

    public String ifModifiedSince() {
        return "If-Modified-Since";
    }

    public String ifNoneMatch() {
        return "If-None-Match";
    }

    public String ifRange() {
        return "If-Range";
    }

    public String ifUnmodifiedSince() {
        return "If-Unmodified-Since";
    }

    public String lastModified() {
        return "Last-Modified";
    }

    public String link() {
        return "Link";
    }

    public String location() {
        return "Location";
    }

    public String max_forwards() {
        return "Max-Forwards";
    }

    public String origin() {
        return "Origin";
    }

    public String pragma() {
        return "Pragma";
    }

    public String proxyAuthenticate() {
        return "Proxy-Authenticate";
    }

    public String proxyAuthorization() {
        return "Proxy-Authorization";
    }

    public String range() {
        return "Range";
    }

    public String referer() {
        return "Referer";
    }

    public String retryAfter() {
        return "Retry-After";
    }

    public String server() {
        return "Server";
    }

    public String setCookie() {
        return "Set-Cookie";
    }

    public String setCookie2() {
        return "Set-Cookie2";
    }

    public String te() {
        return "TE";
    }

    public String trailer() {
        return "Trailer";
    }

    public String transferEncoding() {
        return "Transfer-Encoding";
    }

    public String upgrade() {
        return "Upgrade";
    }

    public String user_agent() {
        return "User-Agent";
    }

    public String vary() {
        return "Vary";
    }

    public String via() {
        return "Via";
    }

    public String warning() {
        return "Warning";
    }

    public String wwwAuthenticate() {
        return "WWW-Authenticate";
    }

    public String allValue() {
        return "*/*";
    }

    public String applicationAtomXml() {
        return "application/atom+xml";
    }

    public String applicationFormUrlencoded() {
        return "application/x-www-form-urlencoded";
    }

    public String applicationJson() {
        return "application/json";
    }

    public String applicationJsonUtf8() {
        return "application/json;charset=UTF-8";
    }

    public String applicationOctetStream() {
        return "application/octet-stream";
    }

    public String applicationPdf() {
        return "application/pdf";
    }

    public String applicationXhtmlXml() {
        return "application/xhtml+xml";
    }

    public String applicationXml() {
        return "application/xml";
    }

    public String imageGif() {
        return "image/gif";
    }

    public String imageJpeg() {
        return "image/jpeg";
    }

    public String imagePng() {
        return "image/png";
    }

    public String multipartFormData() {
        return "multipart/form-data";
    }

    public String textHtml() {
        return "text/html";
    }

    public String textMarkdown() {
        return "text/markdown";
    }

    public String textPlain() {
        return "text/plain";
    }

    public String textXml() {
        return "text/xml";
    }
}

