/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyManagement;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

public class PremanagedDependency {
    final String premanagedVersion;
    final String premanagedScope;
    final Boolean premanagedOptional;
    final Collection<Exclusion> premanagedExclusions;
    final Map<String, String> premanagedProperties;
    final int managedBits;
    final Dependency managedDependency;
    final boolean premanagedState;

    PremanagedDependency(String premanagedVersion, String premanagedScope, Boolean premanagedOptional, Collection<Exclusion> premanagedExclusions, Map<String, String> premanagedProperties, int managedBits, Dependency managedDependency, boolean premanagedState) {
        this.premanagedVersion = premanagedVersion;
        this.premanagedScope = premanagedScope;
        this.premanagedOptional = premanagedOptional;
        this.premanagedExclusions = premanagedExclusions != null ? Collections.unmodifiableCollection(new ArrayList<Exclusion>(premanagedExclusions)) : null;
        this.premanagedProperties = premanagedProperties != null ? Collections.unmodifiableMap(new HashMap<String, String>(premanagedProperties)) : null;
        this.managedBits = managedBits;
        this.managedDependency = managedDependency;
        this.premanagedState = premanagedState;
    }

    public static PremanagedDependency create(DependencyManager depManager, Dependency dependency, boolean disableVersionManagement, boolean premanagedState) {
        DependencyManagement depMngt = depManager != null ? depManager.manageDependency(dependency) : null;
        int managedBits = 0;
        String premanagedVersion = null;
        String premanagedScope = null;
        Boolean premanagedOptional = null;
        Collection<Exclusion> premanagedExclusions = null;
        Map<String, String> premanagedProperties = null;
        if (depMngt != null) {
            Artifact artifact;
            if (depMngt.getVersion() != null && !disableVersionManagement) {
                artifact = dependency.getArtifact();
                premanagedVersion = artifact.getVersion();
                dependency = dependency.setArtifact(artifact.setVersion(depMngt.getVersion()));
                managedBits |= 1;
            }
            if (depMngt.getProperties() != null) {
                artifact = dependency.getArtifact();
                premanagedProperties = artifact.getProperties();
                dependency = dependency.setArtifact(artifact.setProperties(depMngt.getProperties()));
                managedBits |= 8;
            }
            if (depMngt.getScope() != null) {
                premanagedScope = dependency.getScope();
                dependency = dependency.setScope(depMngt.getScope());
                managedBits |= 2;
            }
            if (depMngt.getOptional() != null) {
                premanagedOptional = dependency.isOptional();
                dependency = dependency.setOptional(depMngt.getOptional());
                managedBits |= 4;
            }
            if (depMngt.getExclusions() != null) {
                premanagedExclusions = dependency.getExclusions();
                dependency = dependency.setExclusions(depMngt.getExclusions());
                managedBits |= 0x10;
            }
        }
        return new PremanagedDependency(premanagedVersion, premanagedScope, premanagedOptional, premanagedExclusions, premanagedProperties, managedBits, dependency, premanagedState);
    }

    public Dependency getManagedDependency() {
        return this.managedDependency;
    }

    public void applyTo(DefaultDependencyNode child) {
        child.setManagedBits(this.managedBits);
        if (this.premanagedState) {
            child.setData("premanaged.version", this.premanagedVersion);
            child.setData("premanaged.scope", this.premanagedScope);
            child.setData("premanaged.optional", this.premanagedOptional);
            child.setData("premanaged.exclusions", this.premanagedExclusions);
            child.setData("premanaged.properties", this.premanagedProperties);
        }
    }
}

