/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.spec.pact;

import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import au.com.dius.pact.consumer.dsl.PactDslJsonBody;
import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.Request;
import au.com.dius.pact.model.Response;
import au.com.dius.pact.model.generators.Category;
import au.com.dius.pact.model.generators.Generator;
import au.com.dius.pact.model.v3.messaging.Message;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.MapFunction;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.EvaluationContext;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.path.PathCompiler;
import groovy.json.JsonException;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.ServerDslProperty;
import org.springframework.cloud.contract.verifier.spec.pact.ValueGeneratorConverter;
import org.springframework.cloud.contract.verifier.util.ContentUtils;

class BodyConverter
implements GroovyObject {
    private static final JsonSlurper jsonSlurper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public BodyConverter() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static DslPart toPactBody(Body body, Closure dslPropertyValueExtractor) {
        return BodyConverter.traverse(body, null, dslPropertyValueExtractor);
    }

    public static DslPart toPactBody(DslProperty dslProperty, Closure dslPropertyValueExtractor) {
        return BodyConverter.traverse(dslProperty, null, dslPropertyValueExtractor);
    }

    private static DslPart traverse(Object value, DslPart parent, Closure dslPropertyValueExtractor) {
        boolean isRoot = parent == null;
        Object v = value;
        if (v instanceof DslProperty) {
            Object object;
            v = object = dslPropertyValueExtractor.call(v);
        }
        if (v instanceof GString) {
            Object object;
            v = object = ContentUtils.extractValue((GString)((GString)ScriptBytecodeAdapter.castToType((Object)v, GString.class)), (Closure)dslPropertyValueExtractor);
        }
        if (v instanceof String) {
            String string = ((String)v).trim();
            v = string;
            if (((String)v).startsWith("{") && ((String)v).endsWith("}")) {
                try {
                    Object object;
                    v = object = jsonSlurper.parseText((String)ScriptBytecodeAdapter.asType((Object)v, String.class));
                }
                catch (JsonException ex) {
                }
            }
        }
        DslPart p = isRoot ? BodyConverter.createRootDslPart(v) : parent;
        if (v instanceof Map) {
            if (!isRoot) {
                PactDslJsonBody pactDslJsonBody = p.object();
                p = pactDslJsonBody;
            }
            BodyConverter.processMap((Map)ScriptBytecodeAdapter.asType((Object)v, Map.class), (PactDslJsonBody)ScriptBytecodeAdapter.asType((Object)p, PactDslJsonBody.class), dslPropertyValueExtractor);
            if (!isRoot) {
                DslPart dslPart;
                p = dslPart = p.closeObject();
            }
        } else if (v instanceof Collection) {
            if (!isRoot) {
                PactDslJsonArray pactDslJsonArray = p.array();
                p = pactDslJsonArray;
            }
            BodyConverter.processCollection((Collection)ScriptBytecodeAdapter.asType((Object)v, Collection.class), (PactDslJsonArray)ScriptBytecodeAdapter.asType((Object)p, PactDslJsonArray.class), dslPropertyValueExtractor);
            if (!isRoot) {
                DslPart dslPart;
                p = dslPart = p.closeArray();
            }
        }
        return p;
    }

    private static DslPart createRootDslPart(Object value) {
        return value instanceof Collection ? new PactDslJsonArray() : new PactDslJsonBody();
    }

    /*
     * WARNING - void declaration
     */
    private static void processCollection(Collection values, PactDslJsonArray jsonArray, Closure dslPropertyValueExtractor) {
        void var2_2;
        Reference jsonArray2 = new Reference((Object)jsonArray);
        Reference dslPropertyValueExtractor2 = new Reference((Object)var2_2);
        public class _processCollection_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dslPropertyValueExtractor;
            private /* synthetic */ Reference jsonArray;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processCollection_closure1(Object _outerInstance, Object _thisObject, Reference dslPropertyValueExtractor, Reference jsonArray) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.dslPropertyValueExtractor = reference2 = dslPropertyValueExtractor;
                this.jsonArray = reference = jsonArray;
            }

            public Object doCall(Object it) {
                Object v = it;
                if (v instanceof DslProperty) {
                    Object object;
                    v = object = ((Closure)this.dslPropertyValueExtractor.get()).call(v);
                }
                if (v instanceof GString) {
                    Object object;
                    v = object = ContentUtils.extractValue((GString)((GString)ScriptBytecodeAdapter.castToType((Object)v, GString.class)), (Closure)((Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyValueExtractor.get(), Closure.class)));
                }
                if (v == null) {
                    return ((PactDslJsonArray)this.jsonArray.get()).nullValue();
                }
                if (v instanceof String) {
                    return ((PactDslJsonArray)this.jsonArray.get()).string(ShortTypeHandling.castToString((Object)v));
                }
                if (v instanceof Number) {
                    return ((PactDslJsonArray)this.jsonArray.get()).number((Number)ScriptBytecodeAdapter.castToType((Object)v, Number.class));
                }
                return BodyConverter.traverse(it, (DslPart)ScriptBytecodeAdapter.castToType((Object)this.jsonArray.get(), DslPart.class), (Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyValueExtractor.get(), Closure.class));
            }

            public Closure getDslPropertyValueExtractor() {
                return (Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyValueExtractor.get(), Closure.class);
            }

            public PactDslJsonArray getJsonArray() {
                return (PactDslJsonArray)ScriptBytecodeAdapter.castToType((Object)this.jsonArray.get(), PactDslJsonArray.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processCollection_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        values.forEach((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _processCollection_closure1(BodyConverter.class, BodyConverter.class, dslPropertyValueExtractor2, jsonArray2)), Consumer.class));
    }

    /*
     * WARNING - void declaration
     */
    private static void processMap(Map<String, Object> values, PactDslJsonBody jsonObject, Closure dslPropertyValueExtractor) {
        void var2_2;
        Reference jsonObject2 = new Reference((Object)jsonObject);
        Reference dslPropertyValueExtractor2 = new Reference((Object)var2_2);
        public class _processMap_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dslPropertyValueExtractor;
            private /* synthetic */ Reference jsonObject;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processMap_closure2(Object _outerInstance, Object _thisObject, Reference dslPropertyValueExtractor, Reference jsonObject) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.dslPropertyValueExtractor = reference2 = dslPropertyValueExtractor;
                this.jsonObject = reference = jsonObject;
            }

            public Object doCall(String k, Object v) {
                if (v instanceof DslProperty) {
                    Object object;
                    v = object = ((Closure)this.dslPropertyValueExtractor.get()).call(v);
                }
                if (v instanceof GString) {
                    Object object;
                    v = object = ContentUtils.extractValue((GString)((GString)ScriptBytecodeAdapter.castToType((Object)v, GString.class)), (Closure)((Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyValueExtractor.get(), Closure.class)));
                }
                if (v == null) {
                    return ((PactDslJsonBody)this.jsonObject.get()).nullValue(k);
                }
                if (v instanceof String) {
                    return ((PactDslJsonBody)this.jsonObject.get()).stringType(k, ShortTypeHandling.castToString((Object)v));
                }
                if (v instanceof Number) {
                    return ((PactDslJsonBody)this.jsonObject.get()).numberValue(k, (Number)ScriptBytecodeAdapter.castToType((Object)v, Number.class));
                }
                PactDslJsonBody current = ((PactDslJsonBody)this.jsonObject.get()).object(k);
                BodyConverter.traverse(v, (DslPart)current, (Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyValueExtractor.get(), Closure.class));
                return current.closeObject();
            }

            public Object call(String k, Object v) {
                return this.doCall(k, v);
            }

            public Closure getDslPropertyValueExtractor() {
                return (Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyValueExtractor.get(), Closure.class);
            }

            public PactDslJsonBody getJsonObject() {
                return (PactDslJsonBody)ScriptBytecodeAdapter.castToType((Object)this.jsonObject.get(), PactDslJsonBody.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processMap_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        values.forEach((BiConsumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _processMap_closure2(BodyConverter.class, BodyConverter.class, dslPropertyValueExtractor2, jsonObject2)), BiConsumer.class));
    }

    public static Object toSCCBody(Request request) {
        Object body = BodyConverter.parseBody(request.getBody());
        if (request.getGenerators().isNotEmpty() && request.getGenerators().getCategories().containsKey(Category.BODY)) {
            public class _toSCCBody_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _toSCCBody_closure3(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object currentValue, Pattern pattern, Object generatedValue) {
                    return new DslProperty((Object)new ClientDslProperty((Object)pattern, generatedValue), currentValue);
                }

                public Object call(Object currentValue, Pattern pattern, Object generatedValue) {
                    return this.doCall(currentValue, pattern, generatedValue);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _toSCCBody_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            BodyConverter.applyGenerators(body, (Map)ScriptBytecodeAdapter.castToType(request.getGenerators().getCategories().get(Category.BODY), Map.class), new _toSCCBody_closure3(BodyConverter.class, BodyConverter.class));
        }
        return body;
    }

    public static Object toSCCBody(Response response) {
        Object body = BodyConverter.parseBody(response.getBody());
        if (response.getGenerators().isNotEmpty() && response.getGenerators().getCategories().containsKey(Category.BODY)) {
            public class _toSCCBody_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _toSCCBody_closure4(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object currentValue, Pattern pattern, Object generatedValue) {
                    return new DslProperty(currentValue, (Object)new ServerDslProperty((Object)pattern, generatedValue));
                }

                public Object call(Object currentValue, Pattern pattern, Object generatedValue) {
                    return this.doCall(currentValue, pattern, generatedValue);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _toSCCBody_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            BodyConverter.applyGenerators(body, (Map)ScriptBytecodeAdapter.castToType(response.getGenerators().getCategories().get(Category.BODY), Map.class), new _toSCCBody_closure4(BodyConverter.class, BodyConverter.class));
        }
        return body;
    }

    public static Object toSCCBody(Message message) {
        Object body = BodyConverter.parseBody(message.getContents());
        if (message.getGenerators().isNotEmpty() && message.getGenerators().getCategories().containsKey(Category.BODY)) {
            public class _toSCCBody_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _toSCCBody_closure5(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object currentValue, Pattern pattern, Object generatedValue) {
                    return new DslProperty((Object)new ClientDslProperty((Object)pattern, generatedValue), currentValue);
                }

                public Object call(Object currentValue, Pattern pattern, Object generatedValue) {
                    return this.doCall(currentValue, pattern, generatedValue);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _toSCCBody_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            BodyConverter.applyGenerators(body, (Map)ScriptBytecodeAdapter.castToType(message.getGenerators().getCategories().get(Category.BODY), Map.class), new _toSCCBody_closure5(BodyConverter.class, BodyConverter.class));
        }
        return body;
    }

    private static Object parseBody(OptionalBody optionalBody) {
        if (optionalBody.isPresent()) {
            return new JsonSlurper().parseText(optionalBody.getValue());
        }
        return optionalBody.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static void applyGenerators(Object body, Map<String, Generator> generatorsPerPath, Closure<DslProperty> dslPropertyProvider) {
        void var2_2;
        Reference body2 = new Reference(body);
        Reference dslPropertyProvider2 = new Reference((Object)var2_2);
        Reference configuration = new Reference((Object)Configuration.defaultConfiguration());
        public class _applyGenerators_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference body;
            private /* synthetic */ Reference configuration;
            private /* synthetic */ Reference dslPropertyProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _applyGenerators_closure6(Object _outerInstance, Object _thisObject, Reference body, Reference configuration, Reference dslPropertyProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.body = reference3 = body;
                this.configuration = reference2 = configuration;
                this.dslPropertyProvider = reference = dslPropertyProvider;
            }

            public Object doCall(String path, Generator generator) {
                Reference generator2 = new Reference((Object)generator);
                Path compiledPath = PathCompiler.compile((String)path, (Predicate[])new Predicate[0]);
                EvaluationContext evaluationContext = compiledPath.evaluate(this.body.get(), this.body.get(), (Configuration)ScriptBytecodeAdapter.castToType((Object)this.configuration.get(), Configuration.class), true);
                public class _closure7
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference generator;
                    private /* synthetic */ Reference dslPropertyProvider;
                    private /* synthetic */ Reference configuration;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure7(Object _outerInstance, Object _thisObject, Reference generator, Reference dslPropertyProvider, Reference configuration) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.generator = reference3 = generator;
                        this.dslPropertyProvider = reference2 = dslPropertyProvider;
                        this.configuration = reference = configuration;
                    }

                    public Object doCall(PathRef pathRef) {
                        public class _closure8
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference generator;
                            private /* synthetic */ Reference dslPropertyProvider;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure8(Object _outerInstance, Object _thisObject, Reference generator, Reference dslPropertyProvider) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                this.generator = reference2 = generator;
                                this.dslPropertyProvider = reference = dslPropertyProvider;
                            }

                            public Object doCall(Object currentValue, Configuration config) {
                                Reference currentValue2 = new Reference(currentValue);
                                public class _closure9
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference dslPropertyProvider;
                                    private /* synthetic */ Reference currentValue;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure9(Object _outerInstance, Object _thisObject, Reference dslPropertyProvider, Reference currentValue) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        this.dslPropertyProvider = reference2 = dslPropertyProvider;
                                        this.currentValue = reference = currentValue;
                                    }

                                    public Object doCall(Pattern pattern, Object generatedValue) {
                                        return ((Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyProvider.get(), Closure.class)).call(new Object[]{this.currentValue.get(), pattern, generatedValue});
                                    }

                                    public Object call(Pattern pattern, Object generatedValue) {
                                        return this.doCall(pattern, generatedValue);
                                    }

                                    public Closure getDslPropertyProvider() {
                                        return (Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyProvider.get(), Closure.class);
                                    }

                                    public Object getCurrentValue() {
                                        return this.currentValue.get();
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure9.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }
                                }
                                return ValueGeneratorConverter.convert((Generator)ScriptBytecodeAdapter.castToType((Object)this.generator.get(), Generator.class), new _closure9((Object)this, this.getThisObject(), this.dslPropertyProvider, currentValue2));
                            }

                            public Object call(Object currentValue, Configuration config) {
                                Reference currentValue2 = new Reference(currentValue);
                                return this.doCall(currentValue2.get(), config);
                            }

                            public Generator getGenerator() {
                                return (Generator)ScriptBytecodeAdapter.castToType((Object)this.generator.get(), Generator.class);
                            }

                            public Closure getDslPropertyProvider() {
                                return (Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyProvider.get(), Closure.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure8.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        pathRef.convert((MapFunction)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure8((Object)this, this.getThisObject(), this.generator, this.dslPropertyProvider)), MapFunction.class), (Configuration)ScriptBytecodeAdapter.castToType((Object)this.configuration.get(), Configuration.class));
                        return null;
                    }

                    public Object call(PathRef pathRef) {
                        return this.doCall(pathRef);
                    }

                    public Generator getGenerator() {
                        return (Generator)ScriptBytecodeAdapter.castToType((Object)this.generator.get(), Generator.class);
                    }

                    public Closure getDslPropertyProvider() {
                        return (Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyProvider.get(), Closure.class);
                    }

                    public Configuration getConfiguration() {
                        return (Configuration)ScriptBytecodeAdapter.castToType((Object)this.configuration.get(), Configuration.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.each((Collection)evaluationContext.updateOperations(), (Closure)new _closure7((Object)this, this.getThisObject(), generator2, this.dslPropertyProvider, this.configuration));
            }

            public Object call(String path, Generator generator) {
                Reference generator2 = new Reference((Object)generator);
                return this.doCall(path, (Generator)generator2.get());
            }

            public Object getBody() {
                return this.body.get();
            }

            public Configuration getConfiguration() {
                return (Configuration)ScriptBytecodeAdapter.castToType((Object)this.configuration.get(), Configuration.class);
            }

            public Closure getDslPropertyProvider() {
                return (Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyProvider.get(), Closure.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _applyGenerators_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(generatorsPerPath, (Closure)new _applyGenerators_closure6(BodyConverter.class, BodyConverter.class, body2, configuration, dslPropertyProvider2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BodyConverter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        JsonSlurper jsonSlurper;
        BodyConverter.jsonSlurper = jsonSlurper = new JsonSlurper();
    }
}

