/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

final class VersionExtractor {
    private VersionExtractor() {
    }

    static String forClass(Class<?> cls) {
        String string;
        String implementationVersion = cls.getPackage().getImplementationVersion();
        if (implementationVersion != null) {
            return implementationVersion;
        }
        URL codeSourceLocation = cls.getProtectionDomain().getCodeSource().getLocation();
        URLConnection connection = codeSourceLocation.openConnection();
        if (connection instanceof JarURLConnection) {
            return VersionExtractor.getImplementationVersion(((JarURLConnection)connection).getJarFile());
        }
        JarFile jarFile = new JarFile(new File(codeSourceLocation.toURI()));
        try {
            string = VersionExtractor.getImplementationVersion(jarFile);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        jarFile.close();
        return string;
    }

    private static String getImplementationVersion(JarFile jarFile) throws IOException {
        return jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }
}

