/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.wiremock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import repackaged.nl.flotsam.xeger.Xeger;
import tools.jackson.core.JsonPointer;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.json.JsonReadFeature;
import tools.jackson.core.util.DefaultIndenter;
import tools.jackson.core.util.DefaultPrettyPrinter;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.IntNode;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.StringNode;

public class WireMockToDslConverter {
    private static final JsonPointer PRIORITY_POINTER = JsonPointer.compile((String)"/priority");
    private static final JsonPointer REQUEST_METHOD_POINTER = JsonPointer.compile((String)"/request/method");
    private static final JsonPointer REQUEST_URL_POINTER = JsonPointer.compile((String)"/request/url");
    private static final JsonPointer REQUEST_URL_PATH_POINTER = JsonPointer.compile((String)"/request/urlPath");
    private static final JsonPointer REQUEST_URL_PATTERN_POINTER = JsonPointer.compile((String)"/request/urlPattern");
    private static final JsonPointer REQUEST_URL_PATH_PATTERN_POINTER = JsonPointer.compile((String)"/request/urlPathPattern");
    private static final JsonPointer REQUEST_HEADERS_POINTER = JsonPointer.compile((String)"/request/headers");
    private static final JsonPointer REQUEST_BODY_POINTER = JsonPointer.compile((String)"/request/bodyPatterns");
    private static final JsonPointer RESPONSE_STATUS_POINTER = JsonPointer.compile((String)"/response/status");
    private static final JsonPointer RESPONSE_BODY_POINTER = JsonPointer.compile((String)"/response/body");
    private static final JsonPointer RESPONSE_HEADERS_POINTER = JsonPointer.compile((String)"/response/headers");
    private static final JsonMapper OBJECT_MAPPER = JsonMapper.builder().configure(JsonReadFeature.ALLOW_JAVA_COMMENTS, true).configure(JsonReadFeature.ALLOW_YAML_COMMENTS, true).configure(JsonReadFeature.ALLOW_UNQUOTED_PROPERTY_NAMES, true).configure(JsonReadFeature.ALLOW_SINGLE_QUOTES, true).build();

    public static String fromWireMockStub(String wireMockStringStub) {
        return new WireMockToDslConverter().convertFromWireMockStub(wireMockStringStub);
    }

    private String convertFromWireMockStub(String wireMockStringStub) {
        JsonNode wireMockStub = this.parseStubDefinition(wireMockStringStub);
        return this.buildPriority(wireMockStub) + "request {\n" + this.buildRequestMethod(wireMockStub) + this.buildRequestUrl(wireMockStub) + this.buildRequestUrlPattern(wireMockStub) + this.buildRequestUrlPathPattern(wireMockStub) + this.buildRequestUrlPath(wireMockStub) + this.buildRequestHeaders(wireMockStub) + this.buildRequestBody(wireMockStub) + "}\nresponse {\n" + this.buildResponseStatus(wireMockStub) + this.buildResponseBody(wireMockStub) + this.buildResponseHeaders(wireMockStub) + "}\n";
    }

    private JsonNode parseStubDefinition(String wireMockStringStub) {
        try {
            return OBJECT_MAPPER.reader().readTree(wireMockStringStub);
        }
        catch (Exception e) {
            throw new RuntimeException("WireMock string stub could not be read", e);
        }
    }

    private String buildPriority(JsonNode wireMockStub) {
        Object priority = "";
        JsonNode priorityNode = wireMockStub.at(PRIORITY_POINTER);
        if (!priorityNode.isMissingNode() && priorityNode.asInt() > 0) {
            priority = "priority " + priorityNode.asInt() + "\n";
        }
        return priority;
    }

    private String buildRequestMethod(JsonNode wireMockStub) {
        Object requestMethod = "";
        JsonNode requestMethodNode = wireMockStub.at(REQUEST_METHOD_POINTER);
        if (requestMethodNode != null) {
            requestMethod = "method '" + requestMethodNode.asString() + "'\n";
        }
        return requestMethod;
    }

    private String buildRequestUrl(JsonNode wireMockStub) {
        Object requestUrl = "";
        JsonNode requestUrlNode = wireMockStub.at(REQUEST_URL_POINTER);
        if (!requestUrlNode.isMissingNode()) {
            requestUrl = "url '" + requestUrlNode.asString() + "'\n";
        }
        return requestUrl;
    }

    private String buildRequestUrlPath(JsonNode wireMockStub) {
        Object requestUrlPath = "";
        JsonNode requestUrlPathNode = wireMockStub.at(REQUEST_URL_PATH_POINTER);
        if (!requestUrlPathNode.isMissingNode()) {
            requestUrlPath = "url '" + requestUrlPathNode.asString() + "'\n";
        }
        return requestUrlPath;
    }

    private String buildRequestUrlPattern(JsonNode wireMockStub) {
        Object requestUrlPattern = "";
        JsonNode requestUrlPatternNode = wireMockStub.at(REQUEST_URL_PATTERN_POINTER);
        if (!requestUrlPatternNode.isMissingNode()) {
            String escapedRequestUrlPatternValue = StringEscapeUtils.escapeJava((String)requestUrlPatternNode.asString());
            requestUrlPattern = "url $(consumer(regex('" + escapedRequestUrlPatternValue + "')), producer('" + new Xeger(escapedRequestUrlPatternValue).generate() + "'))\n";
        }
        return requestUrlPattern;
    }

    private String buildRequestUrlPathPattern(JsonNode wireMockStub) {
        Object requestUrlPathPattern = "";
        JsonNode requestUrlPathPatternNode = wireMockStub.at(REQUEST_URL_PATH_PATTERN_POINTER);
        if (!requestUrlPathPatternNode.isMissingNode()) {
            String escapedRequestUrlPathPatternValue = StringEscapeUtils.escapeJava((String)requestUrlPathPatternNode.asString());
            requestUrlPathPattern = "urlPath $(consumer(regex('" + escapedRequestUrlPathPatternValue + "')), producer('" + new Xeger(escapedRequestUrlPathPatternValue).generate() + "'))'\n";
        }
        return requestUrlPathPattern;
    }

    private String buildRequestHeaders(JsonNode wireMockStub) {
        StringBuilder requestHeadersBuilder = new StringBuilder();
        JsonNode requestHeadersNode = wireMockStub.at(REQUEST_HEADERS_POINTER);
        if (requestHeadersNode.isObject()) {
            requestHeadersBuilder.append("headers {\n");
            JsonNode requestHeadersObjectNode = requestHeadersNode.deepCopy();
            Set fields = requestHeadersObjectNode.properties();
            fields.forEach(c -> {
                requestHeadersBuilder.append("header('").append((String)c.getKey()).append("',");
                ObjectNode headersNode = (ObjectNode)((JsonNode)c.getValue()).deepCopy();
                Iterator headersNodeIterator = headersNode.properties().iterator();
                if (headersNodeIterator.hasNext()) {
                    Map.Entry headerValue = (Map.Entry)headersNodeIterator.next();
                    String header = this.buildHeader((String)headerValue.getKey(), ((JsonNode)headerValue.getValue()).asString());
                    requestHeadersBuilder.append(header).append(")").append("\n");
                }
            });
            requestHeadersBuilder.append("}");
        }
        return requestHeadersBuilder.toString();
    }

    private String buildHeader(String method, String value) {
        switch (method) {
            case "equalTo": {
                return "'" + value + "'";
            }
            case "contains": {
                String regex = "^.*" + value + ".*$";
                return "c(regex('" + StringEscapeUtils.escapeJava((String)regex) + "'))";
            }
        }
        return "c(regex('" + StringEscapeUtils.escapeJava((String)value) + "'))";
    }

    private String buildRequestBody(JsonNode wireMockStub) {
        StringBuilder requestBody = new StringBuilder();
        JsonNode requestBodyNode = wireMockStub.at(REQUEST_BODY_POINTER);
        if (requestBodyNode.isArray()) {
            ArrayNode requestBodyArrayNode = (ArrayNode)requestBodyNode.deepCopy();
            Collection elements = requestBodyArrayNode.elements();
            ArrayList requestBodyObjectNodes = new ArrayList();
            elements.stream().filter(f -> f instanceof ObjectNode).map(f -> (ObjectNode)f).map(ObjectNode::properties).forEachOrdered(requestBodyObjectNodes::addAll);
            requestBodyObjectNodes.stream().filter(b -> ((String)b.getKey()).equals("equalTo")).findFirst().ifPresent(b -> requestBody.append("body ('").append(((JsonNode)b.getValue()).asString()).append("')"));
            requestBodyObjectNodes.stream().filter(b -> ((String)b.getKey()).equals("equalToJson")).findFirst().ifPresent(b -> requestBody.append("body ('").append(((JsonNode)b.getValue()).asString()).append("')"));
            requestBodyObjectNodes.stream().filter(b -> ((String)b.getKey()).equals("matches")).findFirst().ifPresent(b -> requestBody.append("body $(consumer(regex('").append(StringEscapeUtils.escapeJava((String)((JsonNode)b.getValue()).asString())).append("')), producer('").append(new Xeger(StringEscapeUtils.escapeJava((String)((JsonNode)b.getValue()).asString())).generate()).append("'))"));
        }
        return requestBody.toString();
    }

    private String buildResponseStatus(JsonNode wireMockStub) {
        Object responseStatus = "";
        JsonNode responseStatusNode = wireMockStub.at(RESPONSE_STATUS_POINTER);
        if (!responseStatusNode.isMissingNode()) {
            int responseStatusValue = responseStatusNode.asInt();
            responseStatus = (String)responseStatus + "status " + responseStatusValue + "\n";
        }
        return responseStatus;
    }

    private String buildResponseBody(JsonNode wireMockStub) {
        Object responseBody = "";
        JsonNode responseBodyNode = wireMockStub.at(RESPONSE_BODY_POINTER);
        if (responseBodyNode.isInt()) {
            responseBody = (String)responseBody + "body( " + StringEscapeUtils.escapeJava((String)this.buildPrettyPrintResponseBody((IntNode)responseBodyNode)) + ")\n";
        }
        if (responseBodyNode.isString()) {
            responseBody = (String)responseBody + "body( \"" + StringEscapeUtils.escapeJava((String)this.buildPrettyPrintResponseBody((StringNode)responseBodyNode)) + "\")\n";
        }
        return responseBody;
    }

    private String buildPrettyPrintResponseBody(IntNode node) {
        return node.asString();
    }

    private String buildPrettyPrintResponseBody(StringNode node) {
        try {
            String stringNode = node.asString();
            Object intermediateObjectForPrettyPrinting = OBJECT_MAPPER.readerFor(Object.class).readValue(stringNode);
            DefaultIndenter customIndenter = new DefaultIndenter("    ", "\n");
            return OBJECT_MAPPER.writer().with((PrettyPrinter)new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)customIndenter).withObjectIndenter((DefaultPrettyPrinter.Indenter)customIndenter)).writeValueAsString(intermediateObjectForPrettyPrinting);
        }
        catch (Exception e) {
            throw new RuntimeException("WireMock response body could not be pretty printed", e);
        }
    }

    private String buildResponseHeaders(JsonNode wireMockStub) {
        StringBuilder responseHeadersBuilder = new StringBuilder();
        JsonNode requestHeadersNode = wireMockStub.at(RESPONSE_HEADERS_POINTER);
        if (requestHeadersNode.isObject()) {
            responseHeadersBuilder.append("headers {\n");
            JsonNode responseHeadersObjectNode = requestHeadersNode.deepCopy();
            Set fields = responseHeadersObjectNode.properties();
            fields.forEach(c -> responseHeadersBuilder.append("header('").append((String)c.getKey()).append("',").append("'").append(((JsonNode)c.getValue()).asString()).append("')\n"));
            responseHeadersBuilder.append("}");
        }
        return responseHeadersBuilder.toString();
    }
}

