/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.converter;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.verifier.converter.ConversionContractVerifierException;
import org.springframework.cloud.contract.verifier.converter.StubGenerator;
import org.springframework.cloud.contract.verifier.converter.StubGeneratorProvider;
import org.springframework.cloud.contract.verifier.file.ContractFileScanner;
import org.springframework.cloud.contract.verifier.file.ContractFileScannerBuilder;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.util.NamesUtil;
import org.springframework.cloud.contract.verifier.wiremock.DslToWireMockClientConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class RecursiveFilesConverter {
    private static final Log log = LogFactory.getLog(RecursiveFilesConverter.class);
    private final StubGeneratorProvider holder;
    private final File outMappingsDir;
    private final File contractsDslDir;
    private final List<String> excludedFiles;
    private final String includedContracts;
    private final boolean excludeBuildFolders;

    public RecursiveFilesConverter(File stubsOutputDir, File contractsDslDir, List<String> excludedFiles, String includedContracts, boolean excludeBuildFolders, StubGeneratorProvider holder) {
        this.outMappingsDir = stubsOutputDir;
        this.contractsDslDir = contractsDslDir;
        this.excludedFiles = excludedFiles;
        this.includedContracts = includedContracts;
        this.excludeBuildFolders = excludeBuildFolders;
        this.holder = holder == null ? new StubGeneratorProvider() : holder;
    }

    public RecursiveFilesConverter(File stubsOutputDir, File contractsDslDir, List<String> excludedFiles, String includedContracts, boolean excludeBuildFolders) {
        this(stubsOutputDir, contractsDslDir, excludedFiles, includedContracts, excludeBuildFolders, null);
    }

    public void processFiles() {
        ContractFileScanner scanner = new ContractFileScannerBuilder().baseDir(this.contractsDslDir).excluded(new HashSet<String>(this.excludedFiles)).ignored(new HashSet()).included(new HashSet()).includeMatcher(this.includedContracts).build();
        MultiValueMap contracts = scanner.findContractsRecursively();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found the following contracts " + contracts));
        }
        for (Map.Entry entry : contracts.entrySet()) {
            for (ContractMetadata contract : (List)entry.getValue()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will create a stub for contract [" + contract + "]"));
                }
                File sourceFile = contract.getPath().toFile();
                Collection<StubGenerator> stubGenerators = this.holder.allOrDefault(new DslToWireMockClientConverter());
                try {
                    String path = sourceFile.getPath();
                    if (this.excludeBuildFolders && (this.matchesPath(path, "target") || this.matchesPath(path, "build"))) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Exclude build folder is set. Path [" + path + "] contains [target] or [build] in its path"));
                        continue;
                    }
                    if (this.nullOrEmpty(contract) && this.nullOrEmpty(stubGenerators)) continue;
                    int contractsSize = contract.getConvertedContract().size();
                    Path entryKey = (Path)entry.getKey();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Stub Generators [" + stubGenerators + "] will convert contents of [" + entryKey + "]"));
                    }
                    for (StubGenerator stubGenerator : stubGenerators) {
                        Map<Contract, String> convertedContent = stubGenerator.convertContents(RecursiveFilesConverter.last(entryKey).toString(), contract);
                        if (convertedContent == null || convertedContent.isEmpty()) continue;
                        Set<Map.Entry<Contract, String>> entrySet = convertedContent.entrySet();
                        Iterator<Map.Entry<Contract, String>> iterator = entrySet.iterator();
                        int index = 0;
                        while (iterator.hasNext()) {
                            Map.Entry<Contract, String> content = iterator.next();
                            Contract dsl = content.getKey();
                            String converted = content.getValue();
                            if (StringUtils.hasText((String)converted)) {
                                Path absoluteTargetPath = this.createAndReturnTargetDirectory(sourceFile);
                                File newJsonFile = this.createTargetFileWithProperName(stubGenerator, absoluteTargetPath, sourceFile, contractsSize, index, dsl);
                                Files.write(newJsonFile.toPath(), Collections.singletonList(converted), StandardCharsets.UTF_8, new OpenOption[0]);
                            }
                            ++index;
                        }
                    }
                }
                catch (Exception e) {
                    throw new ConversionContractVerifierException("Unable to make conversion of " + sourceFile.getName(), e);
                }
            }
        }
    }

    private static <T> T last(Iterable<T> self) {
        Iterator<T> iterator = self.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException("Cannot access last() element from an empty Iterable");
        }
        T result = null;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    private boolean nullOrEmpty(ContractMetadata contract) {
        return contract.getConvertedContract() == null || this.nullOrEmpty(contract.getConvertedContract());
    }

    private boolean nullOrEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    private boolean matchesPath(String path, String folder) {
        return path.matches("^.*" + File.separator + folder + File.separator + ".*$");
    }

    private Path createAndReturnTargetDirectory(File sourceFile) {
        Path relativePath = Paths.get(this.contractsDslDir.toURI()).relativize(sourceFile.getParentFile().toPath());
        Path absoluteTargetPath = this.outMappingsDir.toPath().resolve(relativePath);
        try {
            Files.createDirectories(absoluteTargetPath, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return absoluteTargetPath;
    }

    private File createTargetFileWithProperName(StubGenerator stubGenerator, Path absoluteTargetPath, File sourceFile, int contractsSize, int index, Contract dsl) {
        String name = this.generateName(dsl, contractsSize, stubGenerator, sourceFile, index);
        File newJsonFile = new File(absoluteTargetPath.toFile(), name);
        log.info((Object)("Creating new stub [" + newJsonFile.getPath() + "]"));
        return newJsonFile;
    }

    private String generateName(Contract dsl, int contractsSize, StubGenerator converter, File sourceFile, int index) {
        String extension;
        String generatedName = converter.generateOutputFileNameForInput(sourceFile.getName());
        boolean hasDot = NamesUtil.hasDot((String)generatedName);
        String string = extension = hasDot ? NamesUtil.afterLastDot((String)generatedName) : "";
        if (StringUtils.hasText((String)dsl.getName()) && StringUtils.hasText((String)extension)) {
            return dsl.getName() + "." + extension;
        }
        if (contractsSize == 1) {
            return generatedName;
        }
        return index + "_" + generatedName;
    }
}

