/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.wiremock;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.verifier.dsl.wiremock.WireMockStubStrategy;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.util.NamesUtil;
import org.springframework.cloud.contract.verifier.wiremock.DslToWireMockConverter;
import org.springframework.util.StringUtils;

public class DslToWireMockClientConverter
extends DslToWireMockConverter {
    private String convertASingleContract(String rootName, ContractMetadata contract, Contract dsl) {
        return new WireMockStubStrategy(rootName, contract, dsl).toWireMockClientStub();
    }

    @Override
    public Map<Contract, String> convertContents(String rootName, ContractMetadata contract) {
        List<Contract> httpContracts = this.httpContracts(contract);
        if (httpContracts.isEmpty()) {
            return new HashMap<Contract, String>();
        }
        if (contract.getConvertedContract().size() == 1) {
            return Collections.singletonMap(DslToWireMockClientConverter.first((List)contract.getConvertedContract()), this.convertASingleContract(rootName, contract, (Contract)DslToWireMockClientConverter.first((List)contract.getConvertedContract())));
        }
        return this.convertContracts(rootName, contract, httpContracts);
    }

    private List<Contract> httpContracts(ContractMetadata contract) {
        return contract.getConvertedContract().stream().filter(c -> c.getRequest() != null).collect(Collectors.toList());
    }

    private Map<Contract, String> convertContracts(String rootName, ContractMetadata contract, List<Contract> contractsWithRequest) {
        LinkedHashMap<Contract, String> convertedContracts = new LinkedHashMap<Contract, String>();
        for (int i = 0; i < contractsWithRequest.size(); ++i) {
            Contract dsl = contractsWithRequest.get(i);
            String name = StringUtils.hasText((String)dsl.getName()) ? NamesUtil.convertIllegalPackageChars((String)dsl.getName()) : rootName + "_" + i;
            convertedContracts.put(dsl, this.convertASingleContract(name, contract, dsl));
        }
        return convertedContracts;
    }

    private static <T> T first(List<T> self) {
        if (self.isEmpty()) {
            throw new NoSuchElementException("Cannot access first() element from an empty List");
        }
        return self.get(0);
    }
}

