/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.Bootstrapper;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.bootstrap.TextEncryptorBindHandler;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.bootstrap.encrypt.RsaProperties;
import org.springframework.cloud.context.encrypt.EncryptorFactory;
import org.springframework.core.env.Environment;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.KeyStoreKeyFactory;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class TextEncryptorConfigBootstrapper
implements Bootstrapper {
    private static final boolean RSA_IS_PRESENT = ClassUtils.isPresent((String)"org.springframework.security.rsa.crypto.RsaSecretEncryptor", null);

    public void intitialize(BootstrapRegistry registry) {
        if (!ClassUtils.isPresent((String)"org.springframework.security.crypto.encrypt.TextEncryptor", null)) {
            return;
        }
        registry.registerIfAbsent(KeyProperties.class, context -> (KeyProperties)((Binder)context.get(Binder.class)).bind("encrypt", KeyProperties.class).orElseGet(KeyProperties::new));
        if (RSA_IS_PRESENT) {
            registry.registerIfAbsent(RsaProperties.class, context -> (RsaProperties)((Binder)context.get(Binder.class)).bind("encrypt.rsa", RsaProperties.class).orElseGet(RsaProperties::new));
        }
        registry.registerIfAbsent(TextEncryptor.class, context -> {
            KeyProperties keyProperties = (KeyProperties)context.get(KeyProperties.class);
            if (TextEncryptorConfigBootstrapper.keysConfigured(keyProperties)) {
                if (RSA_IS_PRESENT) {
                    RsaProperties rsaProperties = (RsaProperties)context.get(RsaProperties.class);
                    return TextEncryptorConfigBootstrapper.rsaTextEncryptor(keyProperties, rsaProperties);
                }
                return new EncryptorFactory(keyProperties.getSalt()).create(keyProperties.getKey());
            }
            return new FailsafeTextEncryptor();
        });
        registry.registerIfAbsent(BindHandler.class, context -> {
            TextEncryptor textEncryptor = (TextEncryptor)context.get(TextEncryptor.class);
            if (textEncryptor != null) {
                KeyProperties keyProperties = (KeyProperties)context.get(KeyProperties.class);
                return new TextEncryptorBindHandler(textEncryptor, keyProperties);
            }
            return null;
        });
        registry.addCloseListener(event -> {
            TextEncryptor textEncryptor;
            RsaProperties rsaProperties;
            if (TextEncryptorConfigBootstrapper.isLegacyBootstrap((Environment)event.getApplicationContext().getEnvironment())) {
                return;
            }
            BootstrapContext bootstrapContext = event.getBootstrapContext();
            KeyProperties keyProperties = (KeyProperties)bootstrapContext.get(KeyProperties.class);
            ConfigurableListableBeanFactory beanFactory = event.getApplicationContext().getBeanFactory();
            if (keyProperties != null) {
                beanFactory.registerSingleton("keyProperties", (Object)keyProperties);
            }
            if (RSA_IS_PRESENT && (rsaProperties = (RsaProperties)bootstrapContext.get(RsaProperties.class)) != null) {
                beanFactory.registerSingleton("rsaProperties", (Object)rsaProperties);
            }
            if ((textEncryptor = (TextEncryptor)bootstrapContext.get(TextEncryptor.class)) != null) {
                beanFactory.registerSingleton("textEncryptor", (Object)textEncryptor);
            }
        });
    }

    public static TextEncryptor rsaTextEncryptor(KeyProperties keyProperties, RsaProperties rsaProperties) {
        KeyProperties.KeyStore keyStore = keyProperties.getKeyStore();
        if (keyStore.getLocation() != null) {
            if (keyStore.getLocation().exists()) {
                return new RsaSecretEncryptor(new KeyStoreKeyFactory(keyStore.getLocation(), keyStore.getPassword().toCharArray()).getKeyPair(keyStore.getAlias(), keyStore.getSecret().toCharArray()), rsaProperties.getAlgorithm(), rsaProperties.getSalt(), rsaProperties.isStrong());
            }
            throw new IllegalStateException("Invalid keystore location");
        }
        return new EncryptorFactory(keyProperties.getSalt()).create(keyProperties.getKey());
    }

    public static boolean keysConfigured(KeyProperties properties) {
        if (TextEncryptorConfigBootstrapper.hasProperty(properties.getKeyStore().getLocation())) {
            return TextEncryptorConfigBootstrapper.hasProperty(properties.getKeyStore().getPassword());
        }
        return TextEncryptorConfigBootstrapper.hasProperty(properties.getKey());
    }

    static boolean hasProperty(Object value) {
        if (value instanceof String) {
            return StringUtils.hasText((String)((String)value));
        }
        return value != null;
    }

    static boolean isLegacyBootstrap(Environment environment) {
        boolean isLegacy = (Boolean)environment.getProperty("spring.config.use-legacy-processing", Boolean.class, (Object)false);
        boolean isBootstrapEnabled = (Boolean)environment.getProperty("spring.cloud.bootstrap.enabled", Boolean.class, (Object)false);
        return isLegacy || isBootstrapEnabled;
    }

    public static class FailsafeTextEncryptor
    implements TextEncryptor {
        public String encrypt(String text) {
            throw new UnsupportedOperationException("No encryption for FailsafeTextEncryptor. Did you configure the keystore correctly?");
        }

        public String decrypt(String encryptedText) {
            throw new UnsupportedOperationException("No decryption for FailsafeTextEncryptor. Did you configure the keystore correctly?");
        }
    }
}

