/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public class EnvironmentDecryptApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    public static final String DECRYPTED_PROPERTY_SOURCE_NAME = "decrypted";
    public static final String DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME = "decryptedBootstrap";
    public static final String ENCRYPTED_PROPERTY_PREFIX = "{cipher}";
    private static final Pattern COLLECTION_PROPERTY = Pattern.compile("(\\S+)?\\[(\\d+)\\](\\.\\S+)?");
    private static Log logger = LogFactory.getLog(EnvironmentDecryptApplicationInitializer.class);
    private int order = -2147483633;
    private TextEncryptor encryptor;
    private boolean failOnError = true;

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public EnvironmentDecryptApplicationInitializer(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ApplicationContext parent;
        Map<String, Object> map;
        PropertySource bootstrap;
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        MutablePropertySources propertySources = environment.getPropertySources();
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        if (!propertySources.contains(DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME) && (bootstrap = propertySources.get("bootstrap")) != null && !(map = this.decrypt(bootstrap)).isEmpty()) {
            found.addAll(map.keySet());
            this.insert((ApplicationContext)applicationContext, (PropertySource<?>)new SystemEnvironmentPropertySource(DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME, map));
        }
        this.removeDecryptedProperties((ApplicationContext)applicationContext);
        Map<String, Object> map2 = this.decrypt((PropertySources)propertySources);
        if (!map2.isEmpty()) {
            found.addAll(map2.keySet());
            this.insert((ApplicationContext)applicationContext, (PropertySource<?>)new SystemEnvironmentPropertySource(DECRYPTED_PROPERTY_SOURCE_NAME, map2));
        }
        if (!found.isEmpty() && (parent = applicationContext.getParent()) != null) {
            parent.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(parent, found));
        }
    }

    private void insert(ApplicationContext applicationContext, PropertySource<?> propertySource) {
        for (ApplicationContext parent = applicationContext; parent != null; parent = parent.getParent()) {
            if (!(parent.getEnvironment() instanceof ConfigurableEnvironment)) continue;
            ConfigurableEnvironment mutable = (ConfigurableEnvironment)parent.getEnvironment();
            this.insert(mutable.getPropertySources(), propertySource);
        }
    }

    private void insert(MutablePropertySources propertySources, PropertySource<?> propertySource) {
        if (propertySources.contains("bootstrap")) {
            if (DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME.equals(propertySource.getName())) {
                propertySources.addBefore("bootstrap", propertySource);
            } else {
                propertySources.addAfter("bootstrap", propertySource);
            }
        } else {
            propertySources.addFirst(propertySource);
        }
    }

    private void removeDecryptedProperties(ApplicationContext applicationContext) {
        for (ApplicationContext parent = applicationContext; parent != null; parent = parent.getParent()) {
            if (!(parent.getEnvironment() instanceof ConfigurableEnvironment)) continue;
            ((ConfigurableEnvironment)parent.getEnvironment()).getPropertySources().remove(DECRYPTED_PROPERTY_SOURCE_NAME);
        }
    }

    public Map<String, Object> decrypt(PropertySources propertySources) {
        Map<String, Object> properties = this.merge(propertySources);
        this.decrypt(properties);
        return properties;
    }

    private Map<String, Object> decrypt(PropertySource<?> source) {
        Map<String, Object> properties = this.merge(source);
        this.decrypt(properties);
        return properties;
    }

    private Map<String, Object> merge(PropertySources propertySources) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
        for (PropertySource source : propertySources) {
            sources.add(0, source);
        }
        for (PropertySource source : sources) {
            this.merge(source, properties);
        }
        return properties;
    }

    private Map<String, Object> merge(PropertySource<?> source) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.merge(source, properties);
        return properties;
    }

    private void merge(PropertySource<?> source, Map<String, Object> properties) {
        if (source instanceof CompositePropertySource) {
            ArrayList sources = new ArrayList(((CompositePropertySource)source).getPropertySources());
            Collections.reverse(sources);
            for (PropertySource nested : sources) {
                this.merge(nested, properties);
            }
        } else if (source instanceof EnumerablePropertySource) {
            LinkedHashMap<String, String> otherCollectionProperties = new LinkedHashMap<String, String>();
            boolean sourceHasDecryptedCollection = false;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            for (String key : enumerable.getPropertyNames()) {
                Object property = source.getProperty(key);
                if (property == null) continue;
                String value = property.toString();
                if (value.startsWith(ENCRYPTED_PROPERTY_PREFIX)) {
                    properties.put(key, value);
                    if (!COLLECTION_PROPERTY.matcher(key).matches()) continue;
                    sourceHasDecryptedCollection = true;
                    continue;
                }
                if (COLLECTION_PROPERTY.matcher(key).matches()) {
                    otherCollectionProperties.put(key, value);
                    continue;
                }
                properties.remove(key);
            }
            if (sourceHasDecryptedCollection && !otherCollectionProperties.isEmpty()) {
                properties.putAll(otherCollectionProperties);
            }
        }
    }

    private void decrypt(Map<String, Object> properties) {
        properties.replaceAll((key, value) -> {
            String valueString = value.toString();
            if (!valueString.startsWith(ENCRYPTED_PROPERTY_PREFIX)) {
                return value;
            }
            return this.decrypt((String)key, valueString);
        });
    }

    private String decrypt(String key, String original) {
        String value = original.substring(ENCRYPTED_PROPERTY_PREFIX.length());
        try {
            value = this.encryptor.decrypt(value);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Decrypted: key=" + key));
            }
            return value;
        }
        catch (Exception e) {
            String message = "Cannot decrypt: key=" + key;
            if (this.failOnError) {
                throw new IllegalStateException(message, e);
            }
            if (logger.isDebugEnabled()) {
                logger.warn((Object)message, (Throwable)e);
            } else {
                logger.warn((Object)message);
            }
            return "";
        }
    }
}

