/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.discovery.ReregistrationPredicate;
import org.springframework.cloud.consul.model.http.agent.NewService;
import org.springframework.cloud.consul.model.http.health.Check;
import org.springframework.cloud.consul.serviceregistry.ApplicationStatusProvider;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.web.client.HttpStatusCodeException;

public class TtlScheduler {
    private static final Log log = LogFactory.getLog(TtlScheduler.class);
    private final Map<String, ScheduledFuture> serviceHeartbeats = new ConcurrentHashMap<String, ScheduledFuture>();
    private final TaskScheduler scheduler = new ConcurrentTaskScheduler(Executors.newSingleThreadScheduledExecutor());
    private final HeartbeatProperties heartbeatProperties;
    private final ConsulDiscoveryProperties discoveryProperties;
    private final ConsulClient client;
    private final ReregistrationPredicate reregistrationPredicate;
    private final Map<String, NewService> registeredServices = new ConcurrentHashMap<String, NewService>();
    private ApplicationStatusProvider applicationStatusProvider;

    public TtlScheduler(HeartbeatProperties heartbeatProperties, ConsulDiscoveryProperties discoveryProperties, ConsulClient client, ReregistrationPredicate reregistrationPredicate, ObjectProvider<ApplicationStatusProvider> applicationStatusProviderFactory) {
        this.heartbeatProperties = heartbeatProperties;
        this.discoveryProperties = discoveryProperties;
        this.client = client;
        this.reregistrationPredicate = reregistrationPredicate;
        this.applicationStatusProvider = (ApplicationStatusProvider)applicationStatusProviderFactory.getIfAvailable(() -> () -> Check.CheckStatus.PASSING);
    }

    public void add(NewService service) {
        this.add(service.getId());
        this.registeredServices.put(service.getId(), service);
    }

    public void add(String instanceId) {
        ScheduledFuture task = this.scheduler.scheduleAtFixedRate((Runnable)new ConsulHeartbeatTask(instanceId, this, () -> this.applicationStatusProvider.currentStatus()), this.heartbeatProperties.computeHeartbeatInterval().toMillis());
        ScheduledFuture previousTask = this.serviceHeartbeats.put(instanceId, task);
        if (previousTask != null) {
            previousTask.cancel(true);
        }
    }

    public void remove(String instanceId) {
        ScheduledFuture task = this.serviceHeartbeats.get(instanceId);
        if (task != null) {
            task.cancel(true);
        }
        this.serviceHeartbeats.remove(instanceId);
        this.registeredServices.remove(instanceId);
    }

    static class ConsulHeartbeatTask
    implements Runnable {
        private final String serviceId;
        private final String checkId;
        private final TtlScheduler ttlScheduler;
        private final Supplier<Check.CheckStatus> statusSupplier;

        ConsulHeartbeatTask(String serviceId, TtlScheduler ttlScheduler, Supplier<Check.CheckStatus> statusSupplier) {
            this.serviceId = serviceId;
            this.checkId = !this.serviceId.startsWith("service:") ? "service:" + this.serviceId : this.serviceId;
            this.statusSupplier = statusSupplier;
            this.ttlScheduler = ttlScheduler;
        }

        @Override
        public void run() {
            ConsulClient client = this.ttlScheduler.client;
            Check.CheckStatus status = this.statusSupplier.get();
            switch (status) {
                case PASSING: {
                    this.possiblyReregisterIfFails(() -> client.agentCheckPass(this.checkId, null, this.ttlScheduler.discoveryProperties.getAclToken()));
                    this.logHeartbeatSent(status);
                    break;
                }
                case WARNING: {
                    this.possiblyReregisterIfFails(() -> client.agentCheckWarn(this.checkId, null, this.ttlScheduler.discoveryProperties.getAclToken()));
                    this.logHeartbeatSent(status);
                    break;
                }
                case CRITICAL: {
                    this.possiblyReregisterIfFails(() -> client.agentCheckFail(this.checkId, null, this.ttlScheduler.discoveryProperties.getAclToken()));
                    this.logHeartbeatSent(status);
                    break;
                }
                default: {
                    log.debug((Object)String.format("Not sending consul heartbeat for %s (%s)", this.checkId, status));
                }
            }
        }

        private void logHeartbeatSent(Check.CheckStatus status) {
            log.debug((Object)String.format("Sent consul heartbeat for %s (%s)", this.checkId, status));
        }

        private void possiblyReregisterIfFails(Runnable consulClientCall) {
            try {
                consulClientCall.run();
            }
            catch (HttpStatusCodeException e) {
                if (this.ttlScheduler.heartbeatProperties.isReregisterServiceOnFailure() && this.ttlScheduler.reregistrationPredicate.isEligible(e)) {
                    log.warn((Object)e.getMessage());
                    NewService registeredService = this.ttlScheduler.registeredServices.get(this.serviceId);
                    if (registeredService != null) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Re-register " + String.valueOf(registeredService)));
                        }
                        this.ttlScheduler.client.agentServiceRegister(this.ttlScheduler.discoveryProperties.getAclToken(), registeredService);
                    } else {
                        log.warn((Object)"The service to re-register is not found.");
                    }
                }
                throw e;
            }
        }
    }
}

