/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.catalog.CatalogServicesRequest;
import io.micrometer.core.annotation.Timed;
import java.math.BigInteger;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class ConsulCatalogWatch
implements ApplicationEventPublisherAware,
SmartLifecycle {
    private static final Log log = LogFactory.getLog(ConsulCatalogWatch.class);
    private final ConsulDiscoveryProperties properties;
    private final ConsulClient consul;
    private final TaskScheduler taskScheduler;
    private final AtomicReference<BigInteger> catalogServicesIndex = new AtomicReference();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ApplicationEventPublisher publisher;
    private ScheduledFuture<?> watchFuture;

    public ConsulCatalogWatch(ConsulDiscoveryProperties properties, ConsulClient consul) {
        this(properties, consul, (TaskScheduler)ConsulCatalogWatch.getTaskScheduler());
    }

    public ConsulCatalogWatch(ConsulDiscoveryProperties properties, ConsulClient consul, TaskScheduler taskScheduler) {
        this.properties = properties;
        this.consul = consul;
        this.taskScheduler = taskScheduler;
    }

    private static ThreadPoolTaskScheduler getTaskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.initialize();
        return taskScheduler;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.watchFuture = this.taskScheduler.scheduleWithFixedDelay(this::catalogServicesWatch, (long)this.properties.getCatalogServicesWatchDelay());
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false) && this.watchFuture != null) {
            this.watchFuture.cancel(true);
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return 0;
    }

    @Timed(value="consul.watch-catalog-services")
    public void catalogServicesWatch() {
        try {
            CatalogServicesRequest request;
            Response response;
            Long consulIndex;
            long index = -1L;
            if (this.catalogServicesIndex.get() != null) {
                index = this.catalogServicesIndex.get().longValue();
            }
            if ((consulIndex = (response = this.consul.getCatalogServices(request = CatalogServicesRequest.newBuilder().setQueryParams(new QueryParams((long)this.properties.getCatalogServicesWatchTimeout(), index)).setToken(this.properties.getAclToken()).build())).getConsulIndex()) != null) {
                this.catalogServicesIndex.set(BigInteger.valueOf(consulIndex));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Received services update from consul: " + String.valueOf(response.getValue()) + ", index: " + consulIndex));
            }
            this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)consulIndex));
        }
        catch (Exception e) {
            log.error((Object)"Error watching Consul CatalogServices", (Throwable)e);
        }
    }
}

