/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.OperationException;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.discovery.ReregistrationPredicate;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;

public class TtlScheduler {
    private static final Log log = LogFactory.getLog(TtlScheduler.class);
    private final Map<String, ScheduledFuture> serviceHeartbeats = new ConcurrentHashMap<String, ScheduledFuture>();
    private final TaskScheduler scheduler = new ConcurrentTaskScheduler(Executors.newSingleThreadScheduledExecutor());
    private final HeartbeatProperties heartbeatProperties;
    private final ConsulDiscoveryProperties discoveryProperties;
    private final ConsulClient client;
    private final ReregistrationPredicate reregistrationPredicate;
    private final Map<String, NewService> registeredServices = new ConcurrentHashMap<String, NewService>();

    public TtlScheduler(HeartbeatProperties heartbeatProperties, ConsulDiscoveryProperties discoveryProperties, ConsulClient client, ReregistrationPredicate reregistrationPredicate) {
        this.heartbeatProperties = heartbeatProperties;
        this.discoveryProperties = discoveryProperties;
        this.client = client;
        this.reregistrationPredicate = reregistrationPredicate;
    }

    public void add(NewService service) {
        this.add(service.getId());
        this.registeredServices.put(service.getId(), service);
    }

    public void add(String instanceId) {
        ScheduledFuture task = this.scheduler.scheduleAtFixedRate((Runnable)new ConsulHeartbeatTask(instanceId, this), this.heartbeatProperties.computeHeartbeatInterval().toMillis());
        ScheduledFuture previousTask = this.serviceHeartbeats.put(instanceId, task);
        if (previousTask != null) {
            previousTask.cancel(true);
        }
    }

    public void remove(String instanceId) {
        ScheduledFuture task = this.serviceHeartbeats.get(instanceId);
        if (task != null) {
            task.cancel(true);
        }
        this.serviceHeartbeats.remove(instanceId);
        this.registeredServices.remove(instanceId);
    }

    static class ConsulHeartbeatTask
    implements Runnable {
        private final String serviceId;
        private final String checkId;
        private final TtlScheduler ttlScheduler;

        ConsulHeartbeatTask(String serviceId, TtlScheduler ttlScheduler) {
            this.serviceId = serviceId;
            this.checkId = !this.serviceId.startsWith("service:") ? "service:" + this.serviceId : this.serviceId;
            this.ttlScheduler = ttlScheduler;
        }

        @Override
        public void run() {
            try {
                this.ttlScheduler.client.agentCheckPass(this.checkId, null, this.ttlScheduler.discoveryProperties.getAclToken());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending consul heartbeat for: " + this.checkId));
                }
            }
            catch (OperationException e) {
                if (this.ttlScheduler.heartbeatProperties.isReregisterServiceOnFailure() && this.ttlScheduler.reregistrationPredicate.isEligible(e)) {
                    log.warn((Object)e.getMessage());
                    NewService registeredService = (NewService)this.ttlScheduler.registeredServices.get(this.serviceId);
                    if (registeredService != null) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Re-register " + registeredService));
                        }
                        this.ttlScheduler.client.agentServiceRegister(registeredService, this.ttlScheduler.discoveryProperties.getAclToken());
                    } else {
                        log.warn((Object)"The service to re-register is not found.");
                    }
                }
                throw e;
            }
        }
    }
}

