/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.springframework.boot.bootstrap.BootstrapContext;
import org.springframework.boot.bootstrap.BootstrapRegistry;
import org.springframework.boot.bootstrap.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.cloud.consul.ConsulAutoConfiguration;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.cloud.consul.ConsulProperties;
import org.springframework.cloud.consul.config.ConsulConfigDataResource;
import org.springframework.cloud.consul.config.ConsulConfigIndexes;
import org.springframework.cloud.consul.config.ConsulConfigProperties;
import org.springframework.cloud.consul.config.ConsulPropertySources;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class ConsulConfigDataLocationResolver
implements ConfigDataLocationResolver<ConsulConfigDataResource> {
    public static final String PREFIX = "consul:";
    protected static final List<String> DIR_SUFFIXES = Collections.singletonList("/");
    protected static final List<String> FILES_SUFFIXES = Collections.unmodifiableList(Arrays.asList(".yml", ".yaml", ".properties"));
    private final Log log;

    public ConsulConfigDataLocationResolver(DeferredLogFactory logFactory) {
        this.log = logFactory.getLog(ConsulConfigDataLocationResolver.class);
    }

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        if (!location.hasPrefix(PREFIX)) {
            return false;
        }
        boolean enabled = (Boolean)context.getBinder().bind("spring.cloud.consul.enabled", Boolean.class).orElse((Object)true);
        boolean configEnabled = (Boolean)context.getBinder().bind("spring.cloud.consul.config.enabled", Boolean.class).orElse((Object)true);
        return configEnabled && enabled;
    }

    public List<ConsulConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException {
        return Collections.emptyList();
    }

    public List<ConsulConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        UriComponents locationUri = this.parseLocation(resolverContext, location);
        this.registerBean(resolverContext, ConsulProperties.class, this.loadProperties(resolverContext, locationUri));
        this.registerAndPromoteBean(resolverContext, ConsulClient.class, this::createConsulClient);
        ConsulConfigProperties properties = this.loadConfigProperties(resolverContext);
        ConsulPropertySources consulPropertySources = new ConsulPropertySources(properties, this.log);
        List<ConsulPropertySources.Context> contexts = locationUri == null || CollectionUtils.isEmpty((Collection)locationUri.getPathSegments()) ? consulPropertySources.generateAutomaticContexts(profiles.getAccepted(), false) : this.getCustomContexts(locationUri, properties);
        this.registerAndPromoteBean(resolverContext, ConsulConfigProperties.class, BootstrapRegistry.InstanceSupplier.of((Object)properties));
        this.registerAndPromoteBean(resolverContext, ConsulConfigIndexes.class, BootstrapRegistry.InstanceSupplier.from(ConsulConfigDataIndexes::new));
        return contexts.stream().map(propertySourceContext -> new ConsulConfigDataResource(propertySourceContext.getPath(), properties, consulPropertySources, propertySourceContext.getProfile())).collect(Collectors.toList());
    }

    private BindHandler getBindHandler(ConfigDataLocationResolverContext context) {
        return (BindHandler)context.getBootstrapContext().getOrElse(BindHandler.class, null);
    }

    private List<ConsulPropertySources.Context> getCustomContexts(UriComponents uriComponents, ConsulConfigProperties properties) {
        if (!StringUtils.hasText((String)uriComponents.getPath())) {
            return Collections.emptyList();
        }
        ArrayList<ConsulPropertySources.Context> contexts = new ArrayList<ConsulPropertySources.Context>();
        for (String path : uriComponents.getPath().split(";")) {
            for (String suffix : this.getSuffixes(properties)) {
                contexts.add(new ConsulPropertySources.Context(path + suffix));
            }
        }
        return contexts;
    }

    protected List<String> getSuffixes(ConsulConfigProperties properties) {
        if (properties.getFormat() == ConsulConfigProperties.Format.FILES) {
            return FILES_SUFFIXES;
        }
        return DIR_SUFFIXES;
    }

    @Nullable
    protected UriComponents parseLocation(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        String originalLocation = location.getNonPrefixedValue(PREFIX);
        if (!StringUtils.hasText((String)originalLocation)) {
            return null;
        }
        Object uri = !originalLocation.startsWith("//") ? "consul://" + originalLocation : originalLocation;
        return UriComponentsBuilder.fromUriString((String)uri).build();
    }

    protected <T> void registerAndPromoteBean(ConfigDataLocationResolverContext context, Class<T> type, BootstrapRegistry.InstanceSupplier<T> supplier) {
        this.registerBean(context, type, supplier);
        context.getBootstrapContext().addCloseListener(event -> {
            Object instance = event.getBootstrapContext().get(type);
            String name = "configData" + type.getSimpleName();
            ConfigurableApplicationContext appCtxt = event.getApplicationContext();
            if (!appCtxt.containsBean(name)) {
                appCtxt.getBeanFactory().registerSingleton(name, instance);
            }
        });
    }

    public <T> void registerBean(ConfigDataLocationResolverContext context, Class<T> type, T instance) {
        context.getBootstrapContext().registerIfAbsent(type, BootstrapRegistry.InstanceSupplier.of(instance));
    }

    protected <T> void registerBean(ConfigDataLocationResolverContext context, Class<T> type, BootstrapRegistry.InstanceSupplier<T> supplier) {
        ConfigurableBootstrapContext bootstrapContext = context.getBootstrapContext();
        bootstrapContext.registerIfAbsent(type, supplier);
    }

    protected ConsulClient createConsulClient(BootstrapContext context) {
        ConsulProperties properties = (ConsulProperties)context.get(ConsulProperties.class);
        try {
            return ConsulAutoConfiguration.createNewConsulClient((ConsulProperties)properties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ConsulProperties loadProperties(ConfigDataLocationResolverContext resolverContext, UriComponents location) {
        Binder binder = resolverContext.getBinder();
        ConsulProperties consulProperties = (ConsulProperties)binder.bind("spring.cloud.consul", Bindable.of(ConsulProperties.class), this.getBindHandler(resolverContext)).orElseGet(ConsulProperties::new);
        if (location != null) {
            if (StringUtils.hasText((String)location.getHost())) {
                consulProperties.setHost(location.getHost());
            }
            if (location.getPort() >= 0) {
                consulProperties.setPort(location.getPort());
            }
        }
        return consulProperties;
    }

    protected ConsulConfigProperties loadConfigProperties(ConfigDataLocationResolverContext resolverContext) {
        Binder binder = resolverContext.getBinder();
        BindHandler bindHandler = this.getBindHandler(resolverContext);
        ConsulConfigProperties properties = (ConsulConfigProperties)binder.bind("spring.cloud.consul.config", Bindable.of(ConsulConfigProperties.class), bindHandler).orElseGet(ConsulConfigProperties::new);
        if (!StringUtils.hasText((String)properties.getName())) {
            properties.setName((String)binder.bind("spring.application.name", String.class).orElse((Object)"application"));
        }
        if (!StringUtils.hasText((String)properties.getAclToken())) {
            properties.setAclToken((String)binder.bind("spring.cloud.consul.token", String.class).orElse((Object)((String)binder.bind("consul.token", String.class).orElse(null))));
        }
        return properties;
    }

    protected static class ConsulConfigDataIndexes
    implements ConsulConfigIndexes {
        private final LinkedHashMap<String, Long> indexes = new LinkedHashMap();

        protected ConsulConfigDataIndexes() {
        }

        @Override
        public LinkedHashMap<String, Long> getIndexes() {
            return this.indexes;
        }
    }
}

