/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.cloud.consul.config.ConfigWatch;
import org.springframework.cloud.consul.config.ConsulConfigIndexes;
import org.springframework.cloud.consul.config.ConsulConfigProperties;
import org.springframework.cloud.endpoint.RefreshEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnConsulEnabled
@ConditionalOnProperty(name={"spring.cloud.consul.config.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties
public class ConsulConfigAutoConfiguration {
    public static final String CONFIG_WATCH_TASK_SCHEDULER_NAME = "configWatchTaskScheduler";

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RefreshEndpoint.class})
    @ConditionalOnProperty(name={"spring.cloud.consul.config.watch.enabled"}, matchIfMissing=true)
    protected static class ConsulRefreshConfiguration {
        protected ConsulRefreshConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={ConsulConfigIndexes.class})
        public ConfigWatch configWatch(ConsulConfigProperties properties, ConsulConfigIndexes indexes, ConsulClient consul, @Qualifier(value="configWatchTaskScheduler") TaskScheduler taskScheduler) {
            return new ConfigWatch(properties, consul, indexes.getIndexes(), taskScheduler);
        }

        @Bean(name={"configWatchTaskScheduler"})
        public TaskScheduler configWatchTaskScheduler() {
            return new ThreadPoolTaskScheduler();
        }
    }
}

